/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;

public final class PemData {
    private final Label label;
    private final byte[] base64Data;

    private PemData(Label label, byte[] base64Data) {
        this.label = label;
        this.base64Data = base64Data;
    }

    public InputStream createInputStream() {
        List<InputStream> inputStreams = Arrays.asList(new ByteArrayInputStream(this.label.asciiBeginLabel), new ByteArrayInputStream(this.base64Data), new ByteArrayInputStream(this.label.asciiEndLabel));
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PemData encodePrivateKey(PrivateKey privateKey) {
        byte[] pkcs8Key = privateKey.getEncoded();
        try {
            byte[] base64Data = Base64.getMimeEncoder().encode(pkcs8Key);
            PemData pemData = new PemData(Label.PRIVATE_KEY, base64Data);
            return pemData;
        }
        finally {
            Arrays.fill(pkcs8Key, (byte)0);
        }
    }

    private static enum Label {
        PRIVATE_KEY;

        private final String labelText = this.name().replace('_', ' ');
        private final String beginLabel = String.format("\r\n-----BEGIN %s-----\r\n", this.labelText);
        private final byte[] asciiBeginLabel = this.beginLabel.getBytes(StandardCharsets.US_ASCII);
        private final String endLabel = String.format("\r\n-----END %s-----\r\n", this.labelText);
        private final byte[] asciiEndLabel = this.endLabel.getBytes(StandardCharsets.US_ASCII);
    }
}

