/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.resource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.spi.OracleResourceProvider;

public abstract class AbstractResourceProvider
implements OracleResourceProvider {
    private final String system;
    private final String valueType;
    private final ParameterSetParser parameterSetParser;
    private final Collection<ResourceParameter> parameters;

    protected AbstractResourceProvider(String system, String valueType, ResourceParameter ... parameters) {
        this.system = system;
        this.valueType = valueType;
        this.parameters = Collections.unmodifiableList(Arrays.asList((ResourceParameter[])parameters.clone()));
        ParameterSetParser.Builder parserBuilder = ParameterSetParser.builder();
        for (ResourceParameter parameter : parameters) {
            parameter.configureParser(parserBuilder);
        }
        this.parameterSetParser = parserBuilder.build();
    }

    public final String getName() {
        return "ojdbc-provider-" + this.system + "-" + this.valueType;
    }

    public final Collection<? extends OracleResourceProvider.Parameter> getParameters() {
        return this.parameters;
    }

    protected final ParameterSet parseParameterValues(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.parameterSetParser.parseNamedValues(parameterValues.entrySet().stream().collect(Collectors.toMap(entry -> ((OracleResourceProvider.Parameter)entry.getKey()).name(), entry -> ((CharSequence)entry.getValue()).toString())));
    }
}

