/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.resource;

import java.util.Base64;
import java.util.Map;
import oracle.jdbc.provider.azure.resource.KeyVaultSecretProvider;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.WalletUtils;
import oracle.jdbc.spi.OracleResourceProvider;
import oracle.jdbc.spi.PasswordProvider;
import oracle.jdbc.spi.UsernameProvider;

public class KeyVaultSEPSProvider
extends KeyVaultSecretProvider
implements UsernameProvider,
PasswordProvider {
    private static final ResourceParameter[] SEPS_PARAMETERS = new ResourceParameter[]{new ResourceParameter("walletPassword", CommonParameters.PASSWORD), new ResourceParameter("connectionStringIndex", CommonParameters.CONNECTION_STRING_INDEX)};

    public KeyVaultSEPSProvider() {
        super("key-vault-seps", SEPS_PARAMETERS);
    }

    public String getUsername(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).username();
    }

    public char[] getPassword(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        return this.getWalletCredentials(parameterValues).password();
    }

    private WalletUtils.Credentials getWalletCredentials(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        ParameterSet parameterSet = this.parseParameterValues(parameterValues);
        String secretValue = this.getSecret(parameterValues);
        byte[] walletBytes = Base64.getDecoder().decode(secretValue);
        char[] walletPassword = parameterSet.getOptional(CommonParameters.PASSWORD) != null ? ((String)parameterSet.getOptional(CommonParameters.PASSWORD)).toCharArray() : null;
        String connectionStringIndex = (String)parameterSet.getOptional(CommonParameters.CONNECTION_STRING_INDEX);
        return WalletUtils.getCredentials((byte[])walletBytes, (char[])walletPassword, (String)connectionStringIndex);
    }
}

