/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.resource;

import java.util.stream.Stream;
import oracle.jdbc.provider.azure.authentication.AzureAuthenticationMethod;
import oracle.jdbc.provider.azure.authentication.TokenCredentialFactory;
import oracle.jdbc.provider.resource.AbstractResourceProvider;
import oracle.jdbc.provider.resource.ResourceParameter;

public abstract class AzureResourceProvider
extends AbstractResourceProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("authenticationMethod", TokenCredentialFactory.AUTHENTICATION_METHOD, "auto-detect", AzureResourceProvider::parseAuthenticationMethod), new ResourceParameter("tenantId", TokenCredentialFactory.TENANT_ID), new ResourceParameter("clientId", TokenCredentialFactory.CLIENT_ID), new ResourceParameter("clientCertificatePath", TokenCredentialFactory.CLIENT_CERTIFICATE_PATH), new ResourceParameter("clientCertificatePassword", TokenCredentialFactory.CLIENT_CERTIFICATE_PASSWORD), new ResourceParameter("redirectUri", TokenCredentialFactory.REDIRECT_URL), new ResourceParameter("clientSecret", TokenCredentialFactory.CLIENT_SECRET), new ResourceParameter("username", TokenCredentialFactory.USERNAME), new ResourceParameter("password", TokenCredentialFactory.PASSWORD)};

    protected AzureResourceProvider(String resourceType, ResourceParameter ... parameters) {
        super("azure", resourceType, (ResourceParameter[])Stream.concat(Stream.of(PARAMETERS), Stream.of(parameters)).toArray(ResourceParameter[]::new));
    }

    private static AzureAuthenticationMethod parseAuthenticationMethod(String authenticationMethod) {
        switch (authenticationMethod) {
            case "service-principal": {
                return AzureAuthenticationMethod.SERVICE_PRINCIPLE;
            }
            case "managed-identity": {
                return AzureAuthenticationMethod.MANAGED_IDENTITY;
            }
            case "password": {
                return AzureAuthenticationMethod.PASSWORD;
            }
            case "device-code": {
                return AzureAuthenticationMethod.DEVICE_CODE;
            }
            case "interactive": {
                return AzureAuthenticationMethod.INTERACTIVE;
            }
            case "auto-detect": {
                return AzureAuthenticationMethod.AUTO_DETECT;
            }
        }
        throw new IllegalArgumentException("Unrecognized value: " + authenticationMethod);
    }
}

