/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.oauth;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import java.time.OffsetDateTime;
import java.util.Arrays;
import oracle.jdbc.AccessToken;
import oracle.jdbc.provider.azure.AzureResourceFactory;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.util.JsonWebTokenParser;

public final class AccessTokenFactory
extends AzureResourceFactory<AccessToken> {
    public static final Parameter<String> SCOPE = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<AccessToken> INSTANCE = CachedResourceFactory.create((ResourceFactory)new AccessTokenFactory());

    private AccessTokenFactory() {
    }

    public static ResourceFactory<AccessToken> getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource<AccessToken> request(TokenCredential tokenCredential, ParameterSet parameterSet) {
        AccessToken jdbcAccessToken;
        String scope = (String)parameterSet.getRequired(SCOPE);
        TokenRequestContext context = new TokenRequestContext();
        context.addScopes(new String[]{scope});
        com.azure.core.credential.AccessToken azureAccessToken = (com.azure.core.credential.AccessToken)tokenCredential.getToken(context).block();
        char[] jsonWebToken = azureAccessToken.getToken().toCharArray();
        try {
            jdbcAccessToken = AccessToken.createJsonWebToken((char[])jsonWebToken);
        }
        finally {
            Arrays.fill(jsonWebToken, '\u0000');
        }
        OffsetDateTime expireTime = JsonWebTokenParser.parseExp((CharSequence)azureAccessToken.getToken());
        return Resource.createExpiringResource((Object)jdbcAccessToken, (OffsetDateTime)expireTime, (boolean)true);
    }
}

