/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.azure.configuration;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.provider.azure.configuration.AzureConfigurationParameters;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.provider.parameter.UriParameters;

public class AzureAppConfigurationURLParser {
    private static final String NAME = "([-\\w]+)";
    private static final Pattern CONFIG_URL = Pattern.compile("([-\\w]+)(\\?(.*))", 2);
    public static final Parameter<String> KEY = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    public static final Parameter<String> LABEL = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0]);
    private static final ParameterSetParser PARAMETER_SET_PARSER = AzureConfigurationParameters.configureBuilder(ParameterSetParser.builder().addParameter("KEY", KEY).addParameter("LABEL", LABEL)).build();
    private final ParameterSet parameters;
    private final String name;
    private String prefix;

    public AzureAppConfigurationURLParser(String url) {
        Matcher urlMatcher = CONFIG_URL.matcher(url);
        if (urlMatcher.matches()) {
            this.name = urlMatcher.group(1);
            this.parameters = PARAMETER_SET_PARSER.parseNamedValues(UriParameters.parse((CharSequence)url));
            this.prefix = (String)this.parameters.getOptional(KEY);
        } else {
            this.name = url;
            this.parameters = ParameterSet.empty();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ParameterSet getParameters() {
        return this.parameters;
    }
}

