/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.resource;

import java.util.stream.Stream;
import oracle.jdbc.provider.aws.authentication.AwsAuthenticationMethod;
import oracle.jdbc.provider.aws.authentication.AwsCredentialsFactory;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.resource.AbstractResourceProvider;
import oracle.jdbc.provider.resource.ResourceParameter;

public abstract class AwsResourceProvider
extends AbstractResourceProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("authenticationMethod", AwsCredentialsFactory.AUTHENTICATION_METHOD, "aws-default", AwsResourceProvider::parseAuthenticationMethod), new ResourceParameter("awsRegion", AwsConfigurationParameters.REGION)};

    protected AwsResourceProvider(String resourceType, ResourceParameter ... parameters) {
        super("aws", resourceType, (ResourceParameter[])Stream.concat(Stream.of(PARAMETERS), Stream.of(parameters)).toArray(ResourceParameter[]::new));
    }

    private static AwsAuthenticationMethod parseAuthenticationMethod(String authenticationMethod) {
        switch (authenticationMethod) {
            case "aws-default": {
                return AwsAuthenticationMethod.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unrecognized authentication method: " + authenticationMethod);
    }
}

