/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.configuration;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.aws.secrets.SecretsManagerFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.util.OracleConfigurationCache;

public class AwsSecretsManagerConfigurationProvider
extends OracleConfigurationParsableProvider {
    static final ParameterSetParser PARAMETER_SET_PARSER = AwsConfigurationParameters.configureBuilder(ParameterSetParser.builder().addParameter("value", SecretsManagerFactory.SECRET_NAME).addParameter("key", AwsConfigurationParameters.KEY).addParameter("type", Parameter.create((Parameter.Attribute[])new Parameter.Attribute[0])).addParameter("field_name", AwsConfigurationParameters.FIELD_NAME).addParameter("AWS_REGION", AwsConfigurationParameters.REGION)).build();

    public InputStream getInputStream(String secretName) {
        String valueFieldName = "value";
        HashMap<String, String> optionsWithSecret = new HashMap<String, String>(this.options);
        optionsWithSecret.put("value", secretName);
        ParameterSet parameters = PARAMETER_SET_PARSER.parseNamedValues(optionsWithSecret);
        String secretString = (String)SecretsManagerFactory.getInstance().request(parameters).getContent();
        return new ByteArrayInputStream(secretString.getBytes());
    }

    public String getType() {
        return "awssecretsmanager";
    }

    public OracleConfigurationCache getCache() {
        return CACHE;
    }

    public String getParserType(String location) {
        return "json";
    }
}

