/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.configuration;

import java.io.InputStream;
import java.util.HashMap;
import oracle.jdbc.driver.configuration.OracleConfigurationParsableProvider;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.aws.s3.S3Factory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.util.OracleConfigurationCache;

public class AwsS3ConfigurationProvider
extends OracleConfigurationParsableProvider {
    private static final ParameterSetParser PARAMETER_SET_PARSER = AwsConfigurationParameters.configureBuilder(ParameterSetParser.builder().addParameter("s3_url", S3Factory.S3_URL, "").addParameter("key", AwsConfigurationParameters.KEY).addParameter("AWS_REGION", AwsConfigurationParameters.REGION)).build();

    public InputStream getInputStream(String s3Url) {
        if (!s3Url.startsWith("s3://")) {
            s3Url = "s3://" + s3Url;
        }
        HashMap<String, String> optionsWithUrl = new HashMap<String, String>(this.options);
        optionsWithUrl.put("s3_url", s3Url);
        ParameterSet parameters = PARAMETER_SET_PARSER.parseNamedValues(optionsWithUrl);
        return (InputStream)S3Factory.getInstance().request(parameters).getContent();
    }

    public String getType() {
        return "awss3";
    }

    public OracleConfigurationCache getCache() {
        return CACHE;
    }

    public String getParserType(String location) {
        return "json";
    }
}

