/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.configuration;

import java.util.Map;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.aws.configuration.AwsSecretsManagerConfigurationProvider;
import oracle.jdbc.provider.aws.secrets.AwsSecretExtractor;
import oracle.jdbc.provider.aws.secrets.SecretsManagerFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.util.FileUtils;
import oracle.jdbc.spi.OracleConfigurationSecretProvider;

public class AwsJsonSecretsManagerProvider
implements OracleConfigurationSecretProvider {
    public char[] getSecret(Map<String, String> map) {
        ParameterSet parameterSet = AwsSecretsManagerConfigurationProvider.PARAMETER_SET_PARSER.parseNamedValues(map);
        String fieldName = (String)parameterSet.getOptional(AwsConfigurationParameters.FIELD_NAME);
        String secretString = (String)SecretsManagerFactory.getInstance().request(parameterSet).getContent();
        String extractedSecret = AwsSecretExtractor.extractSecret(secretString, fieldName);
        return FileUtils.toBase64EncodedCharArray((String)extractedSecret);
    }

    public String getSecretType() {
        return "awssecretsmanager";
    }
}

