/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.s3;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import oracle.jdbc.provider.aws.AwsResourceFactory;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class S3Factory
extends AwsResourceFactory<InputStream> {
    public static final Parameter<String> S3_URL = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<InputStream> INSTANCE = new S3Factory();

    private S3Factory() {
    }

    public static ResourceFactory<InputStream> getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource<InputStream> request(AwsCredentials awsCredentials, ParameterSet parameterSet) {
        URI uri;
        String s3Url = (String)parameterSet.getRequired(S3_URL);
        String region = (String)parameterSet.getOptional(AwsConfigurationParameters.REGION);
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().credentialsProvider(() -> awsCredentials);
        if (region != null) {
            builder.region(Region.of((String)region));
        }
        try {
            uri = new URI(s3Url);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException("Failed to parse the string as a URI reference: " + S3_URL, uriSyntaxException);
        }
        try (S3Client client = (S3Client)builder.build();){
            String bucketName = uri.getHost();
            String objectKey = uri.getPath().substring(1);
            GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(objectKey).build();
            Resource resource = Resource.createPermanentResource((Object)client.getObjectAsBytes(getObjectRequest).asInputStream(), (boolean)false);
            return resource;
        }
    }
}

