/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.resource;

import java.util.Map;
import java.util.stream.Stream;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.aws.resource.AwsResourceProvider;
import oracle.jdbc.provider.aws.secrets.AwsSecretExtractor;
import oracle.jdbc.provider.aws.secrets.SecretsManagerFactory;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.ResourceParameterUtils;
import oracle.jdbc.spi.OracleResourceProvider;

public class SecretsManagerSecretProvider
extends AwsResourceProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("secretName", SecretsManagerFactory.SECRET_NAME), new ResourceParameter("fieldName", AwsConfigurationParameters.FIELD_NAME)};

    protected SecretsManagerSecretProvider(String valueType) {
        super(valueType, PARAMETERS);
    }

    protected SecretsManagerSecretProvider(String valueType, ResourceParameter[] additionalParameters) {
        super(valueType, ResourceParameterUtils.combineParameters((ResourceParameter[])PARAMETERS, (ResourceParameter[])additionalParameters));
    }

    protected final String getSecret(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        String secretJson = (String)this.getResource(SecretsManagerFactory.getInstance(), parameterValues);
        ResourceParameter fieldNameParam = Stream.of(PARAMETERS).filter(param -> param.name().equals("fieldName")).findFirst().orElse(null);
        String fieldName = parameterValues.containsKey(fieldNameParam) ? parameterValues.get(fieldNameParam).toString() : null;
        return AwsSecretExtractor.extractSecret(secretJson, fieldName);
    }
}

