/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.authentication;

import java.time.Instant;
import java.time.OffsetDateTime;
import oracle.jdbc.provider.aws.authentication.AwsAuthenticationMethod;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;

public final class AwsCredentialsFactory
implements ResourceFactory<AwsCredentials> {
    public static final Parameter<AwsAuthenticationMethod> AUTHENTICATION_METHOD = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final AwsCredentialsFactory INSTANCE = new AwsCredentialsFactory();

    private AwsCredentialsFactory() {
    }

    public static AwsCredentialsFactory getInstance() {
        return INSTANCE;
    }

    public Resource<AwsCredentials> request(ParameterSet parameterSet) {
        AwsCredentials awsCredentials = AwsCredentialsFactory.getCredential(parameterSet);
        if (awsCredentials.expirationTime().isPresent()) {
            Instant expirationTime = (Instant)awsCredentials.expirationTime().get();
            return Resource.createExpiringResource((Object)awsCredentials, (OffsetDateTime)expirationTime.atOffset(OffsetDateTime.now().getOffset()), (boolean)true);
        }
        return Resource.createPermanentResource((Object)awsCredentials, (boolean)true);
    }

    private static AwsCredentials getCredential(ParameterSet parameterSet) {
        AwsAuthenticationMethod authenticationMethod = (AwsAuthenticationMethod)((Object)parameterSet.getRequired(AUTHENTICATION_METHOD));
        switch (authenticationMethod) {
            case DEFAULT: {
                return AwsCredentialsFactory.defaultCredentials();
            }
        }
        throw new IllegalArgumentException("Unrecognized authentication method: " + (Object)((Object)authenticationMethod));
    }

    private static AwsCredentials defaultCredentials() {
        return DefaultCredentialsProvider.builder().build().resolveCredentials();
    }
}

