/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.aws.secrets;

import oracle.jdbc.provider.aws.AwsResourceFactory;
import oracle.jdbc.provider.aws.configuration.AwsConfigurationParameters;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;

public final class SecretsManagerFactory
extends AwsResourceFactory<String> {
    public static final Parameter<String> SECRET_NAME = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<String> INSTANCE = CachedResourceFactory.create((ResourceFactory)new SecretsManagerFactory());

    private SecretsManagerFactory() {
    }

    public static ResourceFactory<String> getInstance() {
        return INSTANCE;
    }

    @Override
    public Resource<String> request(AwsCredentials awsCredentials, ParameterSet parameterSet) {
        String secretName = (String)parameterSet.getRequired(SECRET_NAME);
        String region = (String)parameterSet.getOptional(AwsConfigurationParameters.REGION);
        SecretsManagerClientBuilder builder = (SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider(() -> awsCredentials);
        if (region != null) {
            builder.region(Region.of((String)region));
        }
        try (SecretsManagerClient client = (SecretsManagerClient)builder.build();){
            GetSecretValueRequest request = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
            GetSecretValueResponse response = client.getSecretValue(request);
            String secretString = response.secretString();
            Resource resource = Resource.createPermanentResource((Object)secretString, (boolean)true);
            return resource;
        }
    }
}

