/*
 * Decompiled with CFR 0.152.
 */
package oracle.simplefan.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.simplefan.FanEvent;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.NodeDownEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.impl.FanEventFactory;

class FanSubscription
implements oracle.simplefan.FanSubscription {
    static final Logger logger = Logger.getLogger("oracle.simplefan.FanSubscription");
    private Thread thread;
    private Subscriber subscriber;
    private final List<FanEventListener> listeners = new ArrayList<FanEventListener>(2);
    private boolean closed;

    static FanSubscription createFanSubscription(String string) throws ONSException {
        FanSubscription fanSubscription = new FanSubscription();
        fanSubscription.subscribe(string);
        fanSubscription.start("oracle.simplefan.FanSubscription:" + string);
        return fanSubscription;
    }

    static FanSubscription createFanSubscription(ONS oNS, String string) throws ONSException {
        FanSubscription fanSubscription = new FanSubscription();
        fanSubscription.subscribe(oNS, string);
        fanSubscription.start("oracle.simplefan.FanSubscription:" + string);
        return fanSubscription;
    }

    private FanSubscription() {
    }

    public void addListener(FanEventListener fanEventListener) {
        if (this.closed) {
            throw new IllegalStateException("attempt to add a listener to a closed subscription");
        }
        logger.fine("adding listener to FanSubscription");
        this.listeners.add(fanEventListener);
    }

    public void removeListener(FanEventListener fanEventListener) {
        logger.fine("removing listener from FanSubscription");
        if (!this.listeners.remove(fanEventListener)) {
            throw new IllegalStateException("attempt to remove a listener that is not attached to the subscriber");
        }
        while (this.listeners.remove(fanEventListener)) {
        }
    }

    public void close() {
        if (!this.closed && null != this.subscriber) {
            logger.fine("close FanSubscription");
            this.closed = true;
            this.thread.interrupt();
        }
    }

    private void start(String string) {
        final FanSubscription fanSubscription = this;
        this.thread = new Thread(new Runnable(){

            public void run() {
                fanSubscription.runInternal();
            }
        }, "FAN Event Handler:" + string);
        this.thread.setDaemon(true);
        this.thread.setPriority(6);
        logger.finest("starting thread to handle FanEvents");
        this.thread.start();
    }

    private void runInternal() {
        Notification notification = null;
        while (!this.closed) {
            try {
                logger.finest("wait for next event");
                notification = this.subscriber.receive(true);
                if (notification != null) {
                    this.handleEvent(notification);
                    continue;
                }
                logger.fine("received null event");
            }
            catch (Throwable throwable) {
                if (this.closed) continue;
                logger.warning("error occured while receiving or handling fan event: " + throwable);
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        logger.fine("closing subscription and terminating thread");
        this.subscriber.close();
    }

    private void handleEvent(Notification notification) {
        logger.finest("handling fan event");
        for (FanEvent fanEvent : FanEventFactory.createFanEvents(this, notification)) {
            FanEvent fanEvent2;
            if (fanEvent instanceof LoadAdvisoryEvent) {
                logger.fine("handling load balancing advisory event");
                fanEvent2 = (LoadAdvisoryEvent)fanEvent;
                for (FanEventListener fanEventListener : this.listeners) {
                    try {
                        fanEventListener.handleEvent((LoadAdvisoryEvent)fanEvent2);
                    }
                    catch (Throwable throwable) {
                        logger.warning("exception while handling load balancing advisory event: " + throwable);
                    }
                }
                continue;
            }
            if (fanEvent instanceof NodeDownEvent) {
                logger.fine("handling node down event");
                fanEvent2 = (NodeDownEvent)fanEvent;
                for (FanEventListener fanEventListener : this.listeners) {
                    try {
                        fanEventListener.handleEvent((NodeDownEvent)fanEvent2);
                    }
                    catch (Throwable throwable) {
                        logger.warning("exception while handling node down event: " + throwable);
                    }
                }
                continue;
            }
            if (fanEvent instanceof ServiceDownEvent) {
                logger.fine("handling service down event");
                fanEvent2 = (ServiceDownEvent)fanEvent;
                for (FanEventListener fanEventListener : this.listeners) {
                    try {
                        fanEventListener.handleEvent((ServiceDownEvent)fanEvent2);
                    }
                    catch (Throwable throwable) {
                        logger.warning("exception while handling service down event: " + throwable);
                    }
                }
                continue;
            }
            logger.severe("INTERNAL ERROR: Unrecognized FanEvent subclass.");
        }
    }

    private void subscribe(String string) throws ONSException {
        logger.finest("attempting to create ONS Subscriber");
        this.subscriber = new Subscriber(this.getEventString(string), "", 30000L);
        logger.finest("got new ONS Subscriber");
    }

    private void subscribe(ONS oNS, String string) throws ONSException {
        logger.finest("attempting to create ONS Subscriber with user configured ONS instance");
        this.subscriber = oNS.createNewSubscriber(this.getEventString(string), "", 30000L);
        logger.finest("got new ONS Subscriber");
    }

    private String getEventString(String string) {
        return "(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")|(%\"eventType=database/event/servicemetrics/" + string + "\")";
    }
}

