/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.net.ssl.SSLSocketFactory;
import oracle.ons.Message;
import oracle.ons.MessageReader;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ServerError;
import oracle.ons.SubscriptionProxy;
import oracle.ons.SystemEvent;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;

class Node
implements SocketCallback {
    static long PING_TIMEOUT = 20000L;
    private final NodeAddress address;
    private final NotificationManager master;
    private final ONSConfiguration conf;
    private ONSSocket socket;
    private volatile long lastMessageTime = 0L;
    private volatile long pingTime = 0L;
    private int protocolVersion = 0;
    private boolean websockActive = false;
    private final AtomicBoolean pinged = new AtomicBoolean(false);
    private final AtomicBoolean waitersAreWaiting = new AtomicBoolean(false);
    private final List<BlockingQueue<Node>> waiters = new ArrayList<BlockingQueue<Node>>();
    private static AtomicInteger globalId = new AtomicInteger(1);
    private final MessageReader messageReader = new MessageReader();
    private final Map<String, ServerSubscriptionProxy> subscriberIndex = new ConcurrentHashMap<String, ServerSubscriptionProxy>();
    private final Map<String, ServerSubscriptionProxy> subscriptionToProxy = new HashMap<String, ServerSubscriptionProxy>();
    private static final int STATE_NOT_CONNECTED = 0;
    private static final int STATE_NOT_INITIALIZED = 1;
    private static final int STATE_INITIALIZED = 2;
    private static final int STATE_SHUTDOWN = 3;
    private AtomicInteger state = new AtomicInteger(0);
    private Set<NotificationNetwork> userSet = new HashSet<NotificationNetwork>();

    public NodeAddress getAddress() {
        return this.address;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    private void sendPingMessage(long l) {
        if (this.pinged.compareAndSet(false, true)) {
            this.master.logger.finest(this.address.toString() + " : Pinging");
            try {
                if (this.protocolVersion >= 5) {
                    this.send(new Message("echo"));
                } else {
                    this.send(new Message("subscribe").put("Subscription", "[").put("SubscriberID", "99"));
                }
                this.pingTime = System.currentTimeMillis();
            }
            catch (ONSException oNSException) {
                this.master.logger.warning(this.address.toString() + " : failed to send ping request: " + ONS.exceptionMsg(oNSException));
                this.close(true);
            }
        } else if (l - this.pingTime > this.conf.getSocketTimeout()) {
            this.master.logger.warning(this.address.toString() + " : Not answered the ping request");
            this.close(true);
        }
    }

    void checkConnection(long l) {
        if (l - this.lastMessageTime <= PING_TIMEOUT) {
            this.pinged.set(false);
            return;
        }
        this.sendPingMessage(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(BlockingQueue<Node> blockingQueue) {
        if (blockingQueue != null) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                this.waiters.add(blockingQueue);
                this.waitersAreWaiting.set(true);
            }
        }
    }

    Node(NotificationManager notificationManager, NodeAddress nodeAddress, ONSConfiguration oNSConfiguration) throws ONSException {
        this.master = notificationManager;
        this.conf = oNSConfiguration;
        this.address = nodeAddress;
        this.messageReader.setWebSocket(nodeAddress.websocket);
        this.master.logger.fine("ONS node: " + this + " (" + this.address.toString() + ")");
    }

    private boolean connect() throws ONSException {
        if (this.state.compareAndSet(0, 1)) {
            this.master.logger.log(Level.FINE, "ONS node connect: " + this + " (" + this.address.toString() + ")");
            this.master.getWorkloadManager().schedule(new NodeConnectAction());
            return true;
        }
        return this.state.get() != 3;
    }

    private void close(boolean bl) {
        this.master.logger.log(Level.FINE, "ONS node close: " + this + " (" + this.address.toString() + ") state: " + this.state.get() + " immediate: " + bl);
        if (this.state.compareAndSet(2, 3) || this.state.compareAndSet(1, 3)) {
            this.master.logger.log(Level.FINE, "ONS node close: " + this + " (" + this.address.toString() + ") action");
            if (!bl) {
                this.onNodeDown();
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    this.master.logger.fine(this.address.toString() + iOException.toString());
                }
            }
            if (bl) {
                this.onNodeDown();
            }
        }
        this.state.set(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean register(NotificationNetwork notificationNetwork) {
        Node node = this;
        synchronized (node) {
            if (this.state.get() == 3) {
                return false;
            }
            this.master.logger.finest(String.format("Network %s is registering at node %s", notificationNetwork.toString(), this.toString()));
            if (this.userSet.add(notificationNetwork) && !this.isConnected()) {
                return this.connect();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(NotificationNetwork notificationNetwork) {
        boolean bl;
        Node node = this;
        synchronized (node) {
            this.userSet.remove(notificationNetwork);
            bl = this.userSet.isEmpty();
        }
        if (bl) {
            this.close(false);
        }
    }

    public boolean isConnected() {
        return this.state.get() == 2;
    }

    public boolean isGarbage() {
        return this.state.get() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Message message) throws ONSException {
        this.master.logger.finest(String.format("Sending message on node %s : %s ", this.address.toString(), message.toString()));
        try {
            Node node = this;
            synchronized (node) {
                OutputStream outputStream = this.socket.getOutputStream();
                if (this.websockActive) {
                    message.send(outputStream, this.address.websocket);
                } else {
                    message.send(outputStream);
                }
                outputStream.flush();
            }
        }
        catch (IOException iOException) {
            throw new ServerError(ONS.exceptionMsg(iOException), message.dump());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processMessage(Notification notification) {
        String[] stringArray;
        boolean bl;
        boolean bl2 = notification.verb.equals("status");
        if (bl2) {
            if (notification.hasProperty("SubscriberID") && notification.get("SubscriberID").equals("99")) {
                this.master.logger.finest("ONS answer to ping from " + this.address.toString());
                return;
            }
        } else if (notification.verb.equals("echoresponse")) {
            this.master.logger.finest("ONS answer to ping from " + this.address.toString());
            return;
        }
        this.master.logger.finer("ONS notification message on node " + this.address.toString() + " of type " + notification.verb);
        this.master.logger.finest("Message : " + notification.toString());
        if (bl2) {
            this.master.logger.fine(String.format("Status message : %s", notification.get("Message")));
        }
        boolean bl3 = bl = bl2 && notification.getResult() == 1;
        if (bl2 && this.state.get() == 1) {
            stringArray = this;
            // MONITORENTER : this
            if (bl) {
                String string;
                this.conf.setInstanceId(notification.get("instanceId"));
                try {
                    this.protocolVersion = Integer.parseInt(notification.get("Version"));
                    if (this.protocolVersion < 4) {
                        this.master.logger.warning("Server " + this.toString() + " version " + String.valueOf(this.protocolVersion) + " is not supported");
                        super.close(true);
                        // MONITOREXIT : stringArray
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.master.logger.warning("Server " + this.toString() + " invalid version: " + notification.get("Version"));
                    super.close(true);
                    // MONITOREXIT : stringArray
                    return;
                }
                if (this.address.websocket.enabled && (string = this.address.websocket.validateResponse(notification)) != null) {
                    this.master.logger.warning("Server " + this.toString() + ": " + string);
                    super.close(true);
                    // MONITOREXIT : stringArray
                    return;
                }
                if (this.state.compareAndSet(1, 2)) {
                    super.onNodeUp();
                }
            }
            // MONITOREXIT : stringArray
        }
        if (this.state.get() != 2) {
            this.close(true);
            return;
        }
        if (!notification.hasProperty("SubscriberID")) return;
        stringArray = notification.getSubscribers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ServerSubscriptionProxy serverSubscriptionProxy = this.subscriberIndex.get(string);
            if (serverSubscriptionProxy == null) {
                this.master.logger.log(Level.WARNING, String.format("Unknown subscriber ID : %s", string));
            } else {
                if (bl2 && notification.getResult() == 1) {
                    serverSubscriptionProxy.setStatus(notification);
                }
                try {
                    serverSubscriptionProxy.populate(notification);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDataAvailable(byte[] byArray, int n, int n2) {
        try {
            this.messageReader.feedBuffer(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new ServerError(ONS.exceptionMsg(exception));
        }
        this.lastMessageTime = System.currentTimeMillis();
        if (this.waitersAreWaiting.get()) {
            List<BlockingQueue<Node>> list = this.waiters;
            synchronized (list) {
                while (!this.waiters.isEmpty()) {
                    this.waiters.remove(this.waiters.size() - 1).add(this);
                }
                this.waitersAreWaiting.set(false);
            }
        }
        while (this.messageReader.available() && this.state.get() != 3) {
            this.processMessage(this.messageReader.remove());
        }
    }

    private synchronized void onNodeUp() {
        this.master.logger.log(Level.FINE, "ONS node up: " + this + " (" + this.address.toString() + ")");
        this.master.onNodeUp(this);
        for (NotificationNetwork notificationNetwork : this.userSet) {
            notificationNetwork.onNodeUp(this);
        }
    }

    private synchronized void onNodeDown() {
        this.master.logger.log(Level.FINE, "ONS node down: " + this + " (" + this.address.toString() + ")");
        this.master.onNodeDown(this);
        for (NotificationNetwork object : this.userSet) {
            object.onNodeDown(this);
        }
        Notification notification = new Notification(new SystemEvent.NodeDown(this), "~InternalNodeDown", null);
        for (ServerSubscriptionProxy serverSubscriptionProxy : this.subscriptionToProxy.values()) {
            try {
                serverSubscriptionProxy.populate(notification);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    void publish(Message message) throws ONSException {
        try {
            this.send(message);
        }
        catch (ONSException oNSException) {
            this.close(true);
            throw oNSException;
        }
    }

    public synchronized void addSubscriber(SubscriptionProxy subscriptionProxy) {
        String string = subscriptionProxy.getSubscriptionKey();
        ServerSubscriptionProxy serverSubscriptionProxy = this.subscriptionToProxy.get(string);
        if (serverSubscriptionProxy == null) {
            serverSubscriptionProxy = new ServerSubscriptionProxy(subscriptionProxy);
            this.master.logger.log(Level.FINEST, "new proxy: fakeId=" + serverSubscriptionProxy.fakeId);
            this.subscriptionToProxy.put(string, serverSubscriptionProxy);
            this.subscriberIndex.put(serverSubscriptionProxy.fakeId, serverSubscriptionProxy);
            try {
                serverSubscriptionProxy.register();
            }
            catch (ONSException oNSException) {
                this.subscriptionToProxy.remove(string);
                this.subscriberIndex.remove(serverSubscriptionProxy.fakeId);
                this.master.logger.log(Level.FINE, "failed to register proxy: fakeId=" + serverSubscriptionProxy.fakeId);
                throw oNSException;
            }
        } else {
            this.master.logger.log(Level.FINEST, "adding subscriber to proxy");
            serverSubscriptionProxy.addSubscriber(subscriptionProxy);
        }
    }

    public synchronized void removeSubscriber(SubscriptionProxy subscriptionProxy) {
        this.master.logger.fine("ONS node " + this + " rem sub proxy: " + subscriptionProxy);
        String string = subscriptionProxy.getSubscriptionKey();
        ServerSubscriptionProxy serverSubscriptionProxy = this.subscriptionToProxy.get(string);
        if (serverSubscriptionProxy != null) {
            serverSubscriptionProxy.proxies.remove(subscriptionProxy);
            if (serverSubscriptionProxy.proxies.isEmpty()) {
                if (serverSubscriptionProxy.registered) {
                    try {
                        this.send(new Message("unsubscribe").put("SubscriberID", serverSubscriptionProxy.fakeId));
                    }
                    catch (ONSException oNSException) {
                        // empty catch block
                    }
                }
                this.subscriptionToProxy.remove(string);
                this.subscriberIndex.remove(serverSubscriptionProxy.fakeId);
            }
        }
    }

    public String toString() {
        return "{address: " + this.address.toString() + "}";
    }

    @Override
    public void hasException(Throwable throwable) {
        String string = throwable.getLocalizedMessage();
        if (string == null && (string = throwable.getMessage()) == null) {
            string = throwable.toString();
        }
        this.master.logger.warning(throwable.getClass().getName() + " : " + string);
        this.close(true);
    }

    private class NodeConnectAction
    implements Runnable {
        private NodeConnectAction() {
        }

        @Override
        public void run() {
            block13: {
                try {
                    int n;
                    String string;
                    boolean bl = false;
                    if (((Node)Node.this).address.websocket.proxyHostname != null) {
                        if (((Node)Node.this).address.websocket.proxySSL == 1) {
                            bl = true;
                        }
                        string = ((Node)Node.this).address.websocket.proxyHostname;
                        n = ((Node)Node.this).address.websocket.proxyPort;
                    } else {
                        if (Node.this.conf.hasSecureConnection()) {
                            bl = true;
                        }
                        string = ((Node)Node.this).address.hostname;
                        n = ((Node)Node.this).address.port;
                    }
                    if (bl) {
                        ((Node)Node.this).master.logger.log(Level.FINE, "Creating configured SSL connection: " + string + ":" + n);
                        Node.this.socket = Node.this.master.getSocketManager().createSocket(string, n, (int)Node.this.conf.getSocketTimeout(), Node.this, Node.this.conf.getSSLSocketFactory());
                    } else if (((Node)Node.this).conf.securityScheme != 3) {
                        ((Node)Node.this).master.logger.log(Level.FINE, "Creating default SSL connection: " + string + ":" + n);
                        Node.this.socket = Node.this.master.getSocketManager().createSocket(string, n, (int)Node.this.conf.getSocketTimeout(), Node.this, (SSLSocketFactory)SSLSocketFactory.getDefault());
                    } else {
                        ((Node)Node.this).master.logger.log(Level.FINE, "Creating connection: " + string + ":" + n);
                        Node.this.socket = Node.this.master.getSocketManager().createSocket(string, n, (int)Node.this.conf.getSocketTimeout(), Node.this);
                    }
                    if (Node.this.state.get() == 1) {
                        Message message = ((Node)Node.this).address.websocket.enabled ? new Message(Node.this.address) : new Message("connect");
                        message.put("Version", Integer.toString(Node.this.conf.getProtocolVersion()));
                        if (((Node)Node.this).address.islocal) {
                            message.put("FormFactor", Node.this.conf.getFormFactor());
                        }
                        message.put("ONSbuildInfo", "Java: ONS_MAIN_LINUX.X64_230724.0002 2023/8/9 15:6:24 UTC");
                        message.put("SelfId", "java (" + ONSConfiguration.getHostname() + "); Home=" + Node.this.conf.getOracleHome()).ready();
                        Node.this.send(message);
                        if (((Node)Node.this).address.websocket.enabled) {
                            Node.this.websockActive = true;
                        }
                        break block13;
                    }
                    Node.this.socket.close();
                    throw new ONSException(String.format("Race condition with node %s: already initialized", Node.this.address.toString()));
                }
                catch (Exception exception) {
                    ((Node)Node.this).master.logger.warning(Node.this.address.toString() + " : " + ONS.exceptionMsg(exception));
                    Node.this.close(true);
                }
            }
        }
    }

    private class ServerSubscriptionProxy {
        private final Collection<SubscriptionProxy> proxies = new ConcurrentLinkedQueue<SubscriptionProxy>();
        private final String fakeId;
        private final Message subscriptionMessage;
        private Notification statusNotification = null;
        private volatile boolean registered = false;

        public ServerSubscriptionProxy(SubscriptionProxy subscriptionProxy) {
            String string;
            while ((string = Integer.toString(globalId.getAndIncrement())).equals("99")) {
            }
            this.fakeId = string;
            ((Node)Node.this).master.logger.log(Level.FINEST, "creating proxy: fakeId=" + this.fakeId);
            this.proxies.add(subscriptionProxy);
            this.subscriptionMessage = new Message(subscriptionProxy.subscriptionMessage);
            this.subscriptionMessage.put("SubscriberID", this.fakeId).ready();
        }

        void populate(Notification notification) throws InterruptedException {
            for (SubscriptionProxy subscriptionProxy : this.proxies) {
                subscriptionProxy.populate(notification);
            }
        }

        private void notifySubscriber(SubscriptionProxy subscriptionProxy) {
            if (this.statusNotification != null) {
                subscriptionProxy.setRegistrationNotification(this.statusNotification);
                subscriptionProxy.setServerSubscriberInfo(Node.this, this.fakeId);
            }
        }

        void addSubscriber(SubscriptionProxy subscriptionProxy) {
            ((Node)Node.this).master.logger.fine("ONS node " + this + " add sub proxy: " + subscriptionProxy);
            this.proxies.add(subscriptionProxy);
            this.notifySubscriber(subscriptionProxy);
        }

        void setStatus(Notification notification) {
            this.registered = true;
            this.statusNotification = notification;
            for (SubscriptionProxy subscriptionProxy : this.proxies) {
                this.notifySubscriber(subscriptionProxy);
            }
        }

        void register() {
            Node.this.send(this.subscriptionMessage);
        }
    }
}

