/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.ons.ConfigurationException;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSException;
import oracle.ons.WebSocket;
import oracle.security.pki.OracleWallet;

public class ONSConfiguration {
    static final long NODE_RETRY_DELAY = 60000L;
    static final long DEFAULT_TIMEOUT = 5000L;
    static final int DEFAULT_REMOTE_TIMEOUT = 30000;
    static final Charset ONS_CHARSET = Charset.forName("ASCII");
    static final String ONS_HP_SEPARATOR = ",";
    static final int BASIC_BUFFER_SIZE = 4096;
    static final int MAX_HEADER_SIZE = 16384;
    static final int DEFAULT_SERVER_VERSION = 6;
    static final int ONS_SECURITY_NONE = 0;
    static final int ONS_SECURITY_ORACLE_WALLET = 1;
    static final int ONS_SECURITY_KEYFILE = 2;
    static final int ONS_SECURITY_LOCAL = 3;
    private int protocolVersion = 6;
    private String oracleHome = "undefined";
    private String instanceId = null;
    private static String cachedHostname = null;
    private int remoteTimeout = 30000;
    private String fingerprint = null;
    private String component = "";
    private String formFactorPath = null;
    private static MessageDigest sha1Digest = null;
    private WebSocket websocket = null;
    String keyFile = null;
    char[] keyFilePassword = null;
    int securityScheme = 0;
    boolean ignoreScan = false;
    private int localPort = 0;
    private int remotePort = 0;
    private int defaultMaxConnections = 3;
    private static final String CONFIG_FILE_PATH = "opmn" + File.separator + "conf";
    private static final String CONFIG_FILE_NAME = "ons.config";
    private static final String FORMFACTOR_FILE_NAME = ".formfactor";
    private static final String SYS_ENV_ORACLE_HOME = "ORACLE_HOME";
    private static final String SYS_ENV_ORACLE_BASE_HOME = "ORACLE_BASE_HOME";
    private static final String SYS_ENV_ORACLE_CONFIG_HOME = "ORACLE_CONFIG_HOME";
    private static final Object defaultConfigLock = new Object();
    private static ONSConfiguration defaultConfig = null;
    final Map<String, NodeList> nodeLists = new HashMap<String, NodeList>();
    private static final Map<String, String> configStringTranslator;
    private static final Pattern commentMatcher;
    private static final String SYSPROP_ORACLEHOME = "oracle.ons.oraclehome";
    private static final String SYSPROP_ORACLEBASEHOME = "oracle.ons.oraclebasehome";
    private static final String SYSPROP_ORACLECONFIGHOME = "oracle.ons.oracleconfighome";
    private static final String SYSPROP_MAXCONNECTIONS = "oracle.ons.maxconnections";
    private static final String SYSPROP_ACTIVELIST = "oracle.ons.active";
    private static final String SYSPROP_SHUTDOWNTIMEOUT = "oracle.ons.shutdowntimeout";
    private static final String SYSPROP_IGNORESCANVIP = "oracle.ons.ignorescanvip";
    private static final String SYSPROP_NODES = "oracle.ons.nodes";
    private static final String SYSPROP_REMOTETIMEOUT = "oracle.ons.remotetimeout";
    private static final String SYSPROP_WALLETFILE = "oracle.ons.walletfile";
    private static final String SYSPROP_WALLETPASSWORD = "oracle.ons.walletpassword";
    private static final String SYSPROP_KEYSTOREFILE = "oracle.ons.keystore.location";
    private static final String SYSPROP_KEYSTOREPASSWORD = "oracle.ons.keystore.password";
    private static final String SYSPROP_DEBUG = "oracle.ons.debug";
    private static final String SYSPROP_PING = "oracle.ons.pingtimeout";
    private static final String SYSPROP_PROPFILE = "oracle.ons.propertiesfile";
    private static final String SYSPROP_USEWEBSOCKET = "oracle.ons.usewebsocket";
    private static final String SYSPROP_WEBSOCKETPROXY = "oracle.ons.websocketproxy";
    protected static final String ONS_SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    protected static final String ONS_SSL_KEY_MANAGEMENT = "SunX509";
    private SSLSocketFactory sslSocketFactoryCached = null;
    private String key = null;

    private void configure(Properties properties) {
        if (properties.containsKey(SYSPROP_PROPFILE)) {
            String string = properties.getProperty(SYSPROP_PROPFILE);
            Properties properties2 = ONSConfiguration.loadProperties(string);
            properties.remove(SYSPROP_PROPFILE);
            properties.putAll((Map<?, ?>)properties2);
        }
        this.setProperties(System.getProperties());
        this.setProperties(properties);
        this.populateTopologies(properties);
        this.updateSSLSocketFactory();
    }

    private static Properties loadProperties(String string) {
        Properties properties = new Properties();
        Reader reader = null;
        try {
            reader = new BufferedReader(new FileReader(string));
            properties.load(reader);
        }
        catch (Exception exception) {
            throw new ConfigurationException(string + ": failed to read configuration file : " + ONS.exceptionMsg(exception));
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    public static ONSConfiguration getRemoteConfigFromString(String string) throws ONSException {
        Properties properties = new Properties();
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        string = string.replace("|", "\n");
        try {
            properties.load(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        oNSConfiguration.configure(ONSConfiguration.translate(properties));
        return oNSConfiguration;
    }

    public ONSConfiguration(String string) throws ONSException {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.configure(ONSConfiguration.translate(properties));
    }

    static String getFileContent(File file) throws IOException {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    static String getFormFactor(String string) throws IOException {
        String string2 = ONSConfiguration.getHostname();
        File file = new File(string, ".formfactor." + string2);
        if (!(file.isFile() || (file = new File(string, FORMFACTOR_FILE_NAME)).isFile() || (file = new File(string, "config" + File.separator + "OPMN" + File.separator + "opmn" + File.separator + FORMFACTOR_FILE_NAME)).isFile())) {
            return "";
        }
        return ONSConfiguration.getFileContent(file).trim();
    }

    static File checkConfigDirectory(String string) {
        File file = new File(string + File.separator + CONFIG_FILE_NAME);
        if (!file.isFile()) {
            file = null;
        }
        return file;
    }

    public static String getUncachedHostname() {
        String string;
        String string2 = System.getenv("HOSTNAME");
        if (string2 == null || string2.isEmpty()) {
            string2 = System.getenv("COMPUTERNAME");
        }
        if ((string = ONSConfiguration.getShortHostname(string2)) == null || string.isEmpty()) {
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                NotificationManager.getNotificationManager();
                NotificationManager.logger.log(Level.WARNING, "Could not get the hostname", unknownHostException);
                string = "";
            }
        }
        return string;
    }

    public static String getShortHostname(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        String string2 = n != -1 ? string.substring(0, n) : string;
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostname() {
        if (cachedHostname == null) {
            String string = ONSConfiguration.getUncachedHostname();
            Object object = defaultConfigLock;
            synchronized (object) {
                if (cachedHostname == null) {
                    cachedHostname = string;
                }
            }
        }
        return cachedHostname;
    }

    public static ONSConfiguration getLocalConfigFromFile(String string, File file, String string2) throws ONSException {
        Object object;
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        File file2 = null;
        if (string == null && file == null) {
            throw new ConfigurationException("Oracle home or config file must be provided");
        }
        if (string == null) {
            file2 = file.getParentFile();
            string = file2.getParentFile().getParentFile().getAbsolutePath();
        }
        if (file2 == null) {
            file2 = new File(string + File.separator + CONFIG_FILE_PATH);
        }
        if (file == null) {
            object = ONSConfiguration.getHostname();
            file = new File(file2, "ons.config." + (String)object);
            if (!file.isFile()) {
                file = new File(file2, CONFIG_FILE_NAME);
            }
        }
        oNSConfiguration.ignoreScan = true;
        oNSConfiguration.setOracleHome(string);
        oNSConfiguration.setFormFactorPath(file2.getAbsolutePath());
        object = ONSConfiguration.loadProperties(file.getAbsolutePath());
        for (String string3 : ((Properties)object).stringPropertyNames()) {
            if (((Properties)object).containsKey(string3.toLowerCase())) continue;
            ((Properties)object).put(string3.toLowerCase(), ((Properties)object).getProperty(string3));
        }
        oNSConfiguration.localPort = Integer.parseInt(ONSConfiguration.cleanupComment(((Properties)object).getProperty("localport", "0")));
        oNSConfiguration.remotePort = Integer.parseInt(ONSConfiguration.cleanupComment(((Properties)object).getProperty("remoteport", "0")));
        if (oNSConfiguration.localPort != 0) {
            oNSConfiguration.securityScheme = 3;
            oNSConfiguration.ignoreScan = true;
        }
        object = ONSConfiguration.translate((Properties)object);
        oNSConfiguration.setProperties(System.getProperties());
        oNSConfiguration.setProperties((Properties)object);
        oNSConfiguration.updateSSLSocketFactory();
        NodeList nodeList = new NodeList("local", oNSConfiguration);
        nodeList.active = true;
        nodeList.addresses.add(new NodeAddress(oNSConfiguration.localPort, false));
        nodeList.maxConnections = 1;
        oNSConfiguration.nodeLists.put(nodeList.publicId, nodeList);
        return oNSConfiguration;
    }

    private static String stringCoalesce(String string, String string2) {
        return string != null ? string : string2;
    }

    public static ONSConfiguration getRemoteConfigFromHome(String string) throws ONSException {
        File file = ONSConfiguration.checkConfigDirectory(string);
        if (file == null) {
            throw new ConfigurationException("ONS configuration file not found");
        }
        ONSConfiguration oNSConfiguration = ONSConfiguration.getRemoteConfigFromFile(file.toString());
        oNSConfiguration.setOracleHome(string);
        return oNSConfiguration;
    }

    public static ONSConfiguration getRemoteConfigFromFile(String string) throws ONSException {
        Properties properties = ONSConfiguration.loadProperties(string);
        ONSConfiguration oNSConfiguration = new ONSConfiguration();
        oNSConfiguration.configure(properties);
        return oNSConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ONSConfiguration getDefaultConfig() throws ONSException {
        if (defaultConfig == null) {
            Object object = defaultConfigLock;
            synchronized (object) {
                if (defaultConfig == null) {
                    return ONSConfiguration.initDefaultConfig();
                }
            }
        }
        return defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfig(ONSConfiguration oNSConfiguration) {
        Object object = defaultConfigLock;
        synchronized (object) {
            defaultConfig = oNSConfiguration;
        }
    }

    static ONSConfiguration initDefaultConfig() throws ONSException {
        Properties properties = System.getProperties();
        String string = null;
        string = properties.getProperty(SYSPROP_ORACLECONFIGHOME);
        if (string == null && (string = properties.getProperty(SYSPROP_ORACLEBASEHOME)) == null && (string = properties.getProperty(SYSPROP_ORACLEHOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_CONFIG_HOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_BASE_HOME)) == null && (string = System.getenv(SYS_ENV_ORACLE_HOME)) == null) {
            throw new ConfigurationException(String.format("Default ONS client initialization: Oracle home is not set (looking in %s)", "oracle.ons.oracleconfighome, oracle.ons.oraclebasehome, oracle.ons.oraclehome"));
        }
        return ONSConfiguration.getLocalConfigFromFile(string, null, null);
    }

    ONSConfiguration() {
    }

    public NotificationNetwork getNetwork() {
        return NotificationManager.getNotificationManager().getNetwork(this);
    }

    public long getNotificationWindow() {
        return 5000L;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public WebSocket getWebSocket() {
        return this.websocket;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public Collection<NodeList> getTopologies() {
        return this.nodeLists.values();
    }

    private static String cleanupComment(String string) {
        int n;
        int n2;
        String string2 = commentMatcher.matcher(string).replaceFirst("");
        char[] cArray = string2.toCharArray();
        for (n2 = n = cArray.length - 1; n2 >= 0 && (cArray[n2] == ' ' || cArray[n2] == '\t'); --n2) {
        }
        if (n2 != n) {
            string2 = n2 >= 0 ? string2.substring(0, n2 + 1) : "";
        }
        return string2;
    }

    private static Properties translate(Properties properties) {
        Properties properties2 = new Properties();
        Iterator<String> iterator = properties.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = iterator.next();
            if (configStringTranslator.containsKey(string)) {
                string2 = configStringTranslator.get(string);
            }
            if (!string2.startsWith("oracle.ons.")) {
                string2 = "oracle.ons." + string2;
            }
            String string3 = ONSConfiguration.cleanupComment(properties.getProperty(string));
            properties2.put(string2, string3);
        }
        return properties2;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getFormFactor() {
        String string = "";
        if (this.formFactorPath != null) {
            try {
                string = ONSConfiguration.getFormFactor(this.formFactorPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    @Deprecated
    public void setFormFactor(String string) {
    }

    public void setFormFactorPath(String string) {
        this.formFactorPath = string;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public String getOracleHome() {
        return this.oracleHome;
    }

    private void setOracleHome(String string) {
        this.oracleHome = string;
    }

    private static synchronized void setSha1Digest() throws NoSuchAlgorithmException {
        if (sha1Digest == null) {
            try {
                sha1Digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                sha1Digest = MessageDigest.getInstance("SHA1");
            }
        }
    }

    public static byte[] getSha1Digest(byte[] byArray) {
        return sha1Digest.digest(byArray);
    }

    public static byte[] getSha1Digest(String string) {
        byte[] byArray = string.getBytes();
        return sha1Digest.digest(byArray);
    }

    public Object getFingerprint() {
        if (this.fingerprint == null) {
            this.fingerprint = this.toString();
        }
        return this.fingerprint;
    }

    private void setProperties(Properties properties) {
        String string;
        if (properties.containsKey(SYSPROP_PING)) {
            Node.PING_TIMEOUT = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_PING)));
        }
        if (properties.containsKey(SYSPROP_IGNORESCANVIP)) {
            this.ignoreScan = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_IGNORESCANVIP)));
        }
        if (properties.containsKey(SYSPROP_REMOTETIMEOUT)) {
            this.remoteTimeout = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_REMOTETIMEOUT)));
        }
        if (properties.containsKey(SYSPROP_MAXCONNECTIONS)) {
            this.defaultMaxConnections = Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS)));
        }
        boolean bl = false;
        if (properties.containsKey(SYSPROP_USEWEBSOCKET)) {
            bl = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_USEWEBSOCKET)));
        }
        if ((string = properties.getProperty(SYSPROP_WEBSOCKETPROXY)) != null) {
            bl = true;
        }
        if (bl) {
            try {
                ONSConfiguration.setSha1Digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new ConfigurationException("SHA-1 is required for websocket support: " + ONS.exceptionMsg(noSuchAlgorithmException));
            }
            if (string != null) {
                try {
                    this.websocket = new WebSocket(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ConfigurationException("Invalid value for oracle.ons.websocketproxy=" + string + " : " + ONS.exceptionMsg(illegalArgumentException));
                }
            } else {
                this.websocket = new WebSocket(true);
            }
        }
        if (this.securityScheme != 3) {
            if (properties.containsKey(SYSPROP_WALLETFILE)) {
                this.securityScheme = 1;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETFILE));
                if (properties.containsKey(SYSPROP_WALLETPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_WALLETPASSWORD)).toCharArray();
                }
            } else if (properties.containsKey(SYSPROP_KEYSTOREFILE)) {
                this.securityScheme = 2;
                this.keyFile = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREFILE));
                if (properties.containsKey(SYSPROP_KEYSTOREPASSWORD)) {
                    this.keyFilePassword = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_KEYSTOREPASSWORD)).toCharArray();
                }
            }
        }
    }

    private void populateTopologies(Properties properties) {
        Object object;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(SYSPROP_NODES) || treeSet.add((String)(object = string.substring(SYSPROP_NODES.length())))) continue;
            throw new ConfigurationException(String.format("Duplicate node list id in configuration : %s", object));
        }
        if (treeSet.isEmpty() && properties.containsKey(SYSPROP_NODES)) {
            treeSet.add("");
        }
        for (String string : treeSet) {
            object = new NodeList(string.isEmpty() ? "" : string.substring(1), this);
            if (properties.containsKey(SYSPROP_ACTIVELIST + string)) {
                ((NodeList)object).active = Boolean.parseBoolean(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_ACTIVELIST + string)));
            }
            ((NodeList)object).maxConnections = properties.containsKey(SYSPROP_MAXCONNECTIONS + string) ? Integer.parseInt(ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_MAXCONNECTIONS + string))) : this.defaultMaxConnections;
            String string2 = ONSConfiguration.cleanupComment(properties.getProperty(SYSPROP_NODES + string));
            for (String string3 : string2.split(ONS_HP_SEPARATOR)) {
                try {
                    int n = string3.lastIndexOf(":");
                    if (n == -1) {
                        throw new IllegalArgumentException();
                    }
                    String string4 = string3.substring(0, n);
                    int n2 = Integer.parseInt(string3.substring(n + 1));
                    NodeAddress nodeAddress = new NodeAddress(string4, n2, this.keyFile, this.websocket);
                    ((NodeList)object).addresses.add(nodeAddress);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ConfigurationException(String.format("Bad node syntax : %s", string3));
                }
            }
            this.nodeLists.put(((NodeList)object).publicId, (NodeList)object);
        }
    }

    public long getSocketTimeout() {
        return this.remoteTimeout;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String string) {
        this.component = string;
    }

    public boolean hasSecureConnection() {
        return this.securityScheme != 0 && this.securityScheme != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateSSLSocketFactory() {
        block26: {
            if (!this.hasSecureConnection()) {
                return;
            }
            try {
                KeyStore keyStore;
                Object object;
                KeyManagerFactory keyManagerFactory = null;
                TrustManagerFactory trustManagerFactory = null;
                boolean bl = this.securityScheme != 1;
                while (true) {
                    try {
                        String string;
                        String string2;
                        if (bl) {
                            string2 = KeyManagerFactory.getDefaultAlgorithm();
                            string = TrustManagerFactory.getDefaultAlgorithm();
                        } else {
                            string2 = ONS_SSL_KEY_MANAGEMENT;
                            string = ONS_SSL_KEY_MANAGEMENT;
                        }
                        keyManagerFactory = KeyManagerFactory.getInstance(string2);
                        trustManagerFactory = TrustManagerFactory.getInstance(string);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        if (bl) {
                            throw noSuchAlgorithmException;
                        }
                        keyManagerFactory = null;
                        bl = true;
                        if (keyManagerFactory == null) continue;
                    }
                    break;
                }
                if (this.securityScheme == 1) {
                    object = new OracleWallet();
                    object.open(this.keyFile, this.keyFilePassword);
                    keyStore = object.getKeyStore();
                } else {
                    if (this.keyFilePassword == null) {
                        throw new ConfigurationException("No password provided");
                    }
                    keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    object = new FileInputStream(this.keyFile);
                    try {
                        keyStore.load((InputStream)object, this.keyFilePassword);
                    }
                    finally {
                        ((FileInputStream)object).close();
                    }
                }
                keyManagerFactory.init(keyStore, this.keyFilePassword);
                trustManagerFactory.init(keyStore);
                object = SSLContext.getInstance(ONS_SSL_CONTEXT_PROTOCOL);
                ((SSLContext)object).init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                if (this.websocket != null && this.websocket.proxyHostname != null) {
                    this.getCertSubjectCN(keyStore);
                    if (this.websocket.proxySSL == 0 && this.websocket.subjectCN != null) {
                        this.websocket.proxySSL = 1;
                    }
                }
                this.sslSocketFactoryCached = ((SSLContext)object).getSocketFactory();
                if (this.sslSocketFactoryCached != null) {
                    NotificationManager.getNotificationManager();
                    NotificationManager.logger.fine("SSL factory created");
                } else {
                    NotificationManager.getNotificationManager();
                    NotificationManager.logger.warning("Failed to create SSL factory");
                }
                if (this.keyFilePassword == null) break block26;
            }
            catch (GeneralSecurityException generalSecurityException) {
                try {
                    throw new ConfigurationException(ONS.exceptionMsg(generalSecurityException));
                    catch (IOException iOException) {
                        throw new ConfigurationException(ONS.exceptionMsg(iOException));
                    }
                }
                catch (Throwable throwable) {
                    if (this.keyFilePassword != null) {
                        for (int i2 = 0; i2 < this.keyFilePassword.length; ++i2) {
                            this.keyFilePassword[i2] = '\u0000';
                        }
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < this.keyFilePassword.length; ++i) {
                this.keyFilePassword[i] = '\u0000';
            }
        }
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.securityScheme == 0 || this.securityScheme == 3) {
            return null;
        }
        if (this.sslSocketFactoryCached == null) {
            try {
                this.updateSSLSocketFactory();
            }
            catch (ONSException oNSException) {
                NotificationManager.getNotificationManager();
                NotificationManager.logger.warning(ONS.exceptionMsg(oNSException));
            }
        }
        return this.sslSocketFactoryCached;
    }

    private void getCertSubjectCN(KeyStore keyStore) {
        Object object = null;
        try {
            Object object2;
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!keyStore.isKeyEntry((String)object2)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                object2 = (X509Certificate)keyStore.getCertificate((String)object);
                String string = ((X509Certificate)object2).getSubjectDN().getName();
                int n = string.indexOf("CN=");
                if (n != -1) {
                    int n2 = string.indexOf(44, n += 3);
                    String string2 = n2 != -1 ? string.substring(n, n2) : string.substring(n);
                    this.websocket.setSubjectCN(string2);
                } else {
                    NotificationManager.getNotificationManager();
                    NotificationManager.logger.log(Level.WARNING, "Could not find CN from cert subject " + string + " in cert " + (String)object + " in key file " + this.keyFile);
                }
            } else {
                NotificationManager.getNotificationManager();
                NotificationManager.logger.log(Level.WARNING, "Could not find cert key name from key file " + this.keyFile);
            }
        }
        catch (Exception exception) {
            if (object != null) {
                NotificationManager.getNotificationManager();
                NotificationManager.logger.log(Level.WARNING, "Could not find CN from cert " + object + " in key file " + this.keyFile);
            }
            NotificationManager.getNotificationManager();
            NotificationManager.logger.log(Level.WARNING, "Could not find cert from key file " + this.keyFile);
        }
    }

    public String toString() {
        if (this.key == null) {
            StringBuilder stringBuilder = new StringBuilder("{");
            stringBuilder.append("ss:").append(this.securityScheme).append(";");
            stringBuilder.append("ff:").append(this.formFactorPath).append(";conf:[");
            for (NodeList nodeList : this.nodeLists.values()) {
                stringBuilder.append(nodeList.toString()).append(ONS_HP_SEPARATOR);
            }
            this.key = stringBuilder.append("]}").toString();
        }
        return this.key;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("keystorelocation", "keystore.location");
        hashMap.put("keystorepassword", "keystore.password");
        configStringTranslator = Collections.unmodifiableMap(hashMap);
        commentMatcher = Pattern.compile("\\s+#.*");
    }

    static class NodeList {
        public String publicId;
        public ONSConfiguration config;
        public final Set<NodeAddress> addresses = new HashSet<NodeAddress>();
        public final Set<NodeAddress> outAddresses = new HashSet<NodeAddress>();
        public final Set<Node> pending = new HashSet<Node>();
        public final Set<Node> connected = new HashSet<Node>();
        public int connectFails;
        public NodeList failedTo;
        public NodeList failedFrom;
        public boolean active = true;
        public int maxConnections = 3;

        public NodeList(String string, ONSConfiguration oNSConfiguration) {
            this.publicId = string;
            this.config = oNSConfiguration;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("{max:%d;a:%b;n:[", this.maxConnections, this.active));
            for (NodeAddress nodeAddress : this.addresses) {
                stringBuilder.append("\"").append(nodeAddress.toString()).append("\";");
            }
            stringBuilder.append("]}");
            return stringBuilder.toString();
        }
    }
}

