/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.function.Consumer;
import oracle.ons.CallBack;
import oracle.ons.Notification;
import oracle.ons.Subscriber;

public interface NotificationCallback
extends CallBack {
    public void notification(Notification var1);

    public void error(Throwable var1);

    default public void system(Notification n) {
    }

    default public void close() {
    }

    @Override
    default public void notification_callback(Notification n) {
        if (n.isSystemNotification()) {
            if (n == Subscriber.loopbackCloseEvent) {
                this.close();
            } else if (n.getException() != null) {
                this.error(n.getException());
            } else {
                this.system(n);
            }
        } else {
            this.notification(n);
        }
    }

    public static class ErrorCallBack
    implements NotificationCallback {
        private final Consumer<Notification> parent;
        private Consumer<Notification> systemHandler;
        private Consumer<Throwable> errorHandler;
        private Runnable onClose;

        public ErrorCallBack(CallBack parent) {
            this.parent = parent::notification_callback;
        }

        public ErrorCallBack(Consumer<Notification> parent, Consumer<Throwable> errorHandler, Runnable onClose) {
            this.parent = parent;
            this.errorHandler = errorHandler;
            this.onClose = onClose;
        }

        public ErrorCallBack(Consumer<Notification> parent) {
            this.parent = parent;
        }

        public ErrorCallBack onClose(Runnable eventHandler) {
            this.onClose = eventHandler;
            return this;
        }

        public ErrorCallBack setSystemHandler(Consumer<Notification> eventHandler) {
            this.systemHandler = eventHandler;
            return this;
        }

        public ErrorCallBack setErrorHandler(Consumer<Throwable> errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        @Override
        public void notification(Notification n) {
            this.parent.accept(n);
        }

        @Override
        public void error(Throwable error) {
            if (this.errorHandler != null) {
                this.errorHandler.accept(error);
            }
        }

        @Override
        public void system(Notification n) {
            if (this.systemHandler != null) {
                this.systemHandler.accept(n);
            }
        }

        @Override
        public void close() {
            if (this.onClose != null) {
                this.onClose.run();
            }
        }
    }
}

