/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;
import oracle.ons.WebSocket;

public class Message {
    protected boolean complete = false;
    protected ByteArrayOutputStream body = new ByteArrayOutputStream(0);
    private ByteArrayOutputStream header = new ByteArrayOutputStream(4096);
    private Writer builder = new OutputStreamWriter((OutputStream)this.header, ONSConfiguration.ONS_CHARSET);

    byte[] dump() {
        return this.header.toByteArray();
    }

    public Message(String verb) {
        try {
            this.builder.append("POST").append(" /").append(verb).append(" HTTP/1.1").append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message(Message x) {
        try {
            x.builder.flush();
            this.body.write(x.body.toByteArray());
            this.header.write(x.header.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message(NodeAddress address) {
        try {
            this.builder.append("GET ons://");
            this.builder.append(address.hostname);
            this.builder.append(":");
            this.builder.append(Integer.toString(address.port));
            this.builder.append(" HTTP/1.1\r\n");
            this.builder.flush();
            address.websocket.createKey(address);
            this.put("Sec-WebSocket-Key", address.websocket.key);
            this.put("Sec-WebSocket-Protocol", "ons");
            this.put("Sec-WebSocket-Version", "13");
            if (address.websocket.subjectCN != null) {
                this.put("Ons-Proxy-Client-Id", address.websocket.putString(address.websocket.subjectCN));
            }
            this.put("Upgrade", "websocket");
            this.put("Connection", "Upgrade");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Message put(String name, String value) {
        try {
            this.builder.append(name).append(": ").append(value).append("\r\n").flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public Message ready() {
        if (this.complete) {
            return this;
        }
        try {
            this.body.close();
            this.put(Notification.internalPropertyList[19], Integer.toString(this.body.size()));
            this.builder.append("\r\n").flush();
            this.builder.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.complete = true;
        return this;
    }

    void send(OutputStream stream) throws IOException {
        this.ready();
        stream.write(this.header.toByteArray());
        stream.write(this.body.toByteArray());
    }

    void send(OutputStream stream, WebSocket websocket) throws IOException {
        this.ready();
        websocket.setMaskOut();
        byte[] headerBytes = this.header.toByteArray();
        byte[] bodyBytes = this.body.toByteArray();
        int msgSize = headerBytes.length + bodyBytes.length;
        byte[] frameBytes = websocket.getFrame(msgSize);
        stream.write(frameBytes);
        websocket.applyMaskOut(headerBytes);
        stream.write(headerBytes);
        if (bodyBytes.length != 0) {
            websocket.applyMaskOut(bodyBytes);
            stream.write(bodyBytes);
        }
    }

    public OutputStream getBodyOutputStream() {
        return this.body;
    }

    public String toString() {
        return this.header.toString();
    }
}

