/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import oracle.ons.CallBackMode;
import oracle.ons.ONS;
import oracle.ons.rpc.RpcRequest;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;

public class RpcServerTest
implements RpcRequestListener {
    private String rpcServerName;
    private String compName;
    private String rpcCallBackName;

    RpcServerTest(String rpcServerName, String compName, String rpcName) {
        this.rpcServerName = rpcServerName;
        this.compName = compName;
        this.rpcCallBackName = rpcName;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new Exception("Usage: java oracle.ons.rpc.impl.RpcServerTest <oracle_home_location> <rpc_server_name> <rpc_callback_name>");
        }
        ONS myONS = new ONS(1, args[0]);
        RpcServerTest rpcServerTest = new RpcServerTest(args[1], "/Component/RpcServerTest", args[2]);
        rpcServerTest.doServer(myONS);
        myONS.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServer(ONS myONS) throws RpcServerException {
        RpcServer server = myONS.createRpcServer(this.rpcServerName, this.compName, null, CallBackMode.SERIAL);
        server.addRequestListener(this.rpcCallBackName, this);
        server.launch();
        RpcServer server2 = myONS.createRpcServer(this.rpcServerName, this.compName, null, CallBackMode.SERIAL);
        server2.addRequestListener(this.rpcCallBackName, this);
        try {
            server2.launch();
            throw new RpcServerException("Registering rpc server " + this.rpcServerName + " should fail");
        }
        catch (RpcServerException e) {
            System.out.println("Caught expected exception: " + e.getMessage());
            System.out.println("Call shutdown on the second rpc server");
            server2.shutdown();
            RpcServerTest rpcServerTest = this;
            synchronized (rpcServerTest) {
                try {
                    this.wait();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            server.shutdown();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRequest(RpcRequest request) {
        String clientRequest = "NULL";
        byte[] arg = request.getArgBytes();
        if (arg != null) {
            clientRequest = new String(arg);
        }
        System.out.println("RPC Server " + this.rpcServerName + " received from RPC Client: '" + clientRequest + "'");
        byte[] response = "HelloWorld".getBytes();
        request.sendResult(response, true);
        RpcServerTest rpcServerTest = this;
        synchronized (rpcServerTest) {
            this.notify();
        }
    }
}

