/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons.rpc.impl;

import java.util.HashMap;
import java.util.Map;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.CallBackSubscriber;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;
import oracle.ons.rpc.impl.RpcRequestImpl;

public final class RpcServerImpl
implements RpcServer,
CallBack {
    private CallBackSubscriber cbsubscriber;
    private String component;
    private ONS myons;
    private String rpcServerName;
    private CallBackMode callBackMode;
    private Map<String, RpcRequestListener> rpcRequestListeners;
    private Map<String, String> addrProperties;
    private boolean isRunning;
    private Publisher publisher;

    public RpcServerImpl(ONS myONS, String rpcServerName, String component, Map<String, String> addrProperties, CallBackMode mode) {
        this.myons = myONS;
        this.component = component;
        this.rpcServerName = rpcServerName;
        this.callBackMode = mode;
        this.cbsubscriber = null;
        this.rpcRequestListeners = new HashMap<String, RpcRequestListener>();
        this.isRunning = false;
        this.addrProperties = addrProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch() throws RpcServerException {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
        }
        this.cbsubscriber = new CallBackSubscriber(this.rpcServerName, this.myons, "\"eventType=_XNOP\"", this.component, this, this.callBackMode, this.addrProperties);
        this.cbsubscriber.start();
        this.publisher = this.cbsubscriber.getPublisher();
        try {
            this.cbsubscriber.waitUntilRegistered();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (!this.isRunning) {
                return;
            }
            this.isRunning = false;
        }
        if (this.cbsubscriber != null) {
            this.cbsubscriber.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRequestListener(String rpcName, RpcRequestListener listener) {
        RpcServerImpl rpcServerImpl = this;
        synchronized (rpcServerImpl) {
            if (rpcName == null) {
                throw new IllegalArgumentException("Cannot add an RPC handler with a null RPC name");
            }
            if (this.rpcRequestListeners.containsKey(rpcName)) {
                throw new IllegalArgumentException("RPC " + rpcName + " is already added to this RPC Server");
            }
            this.rpcRequestListeners.put(rpcName, listener);
        }
    }

    @Override
    public void notification_callback(Notification request) {
        byte[] argsBytes;
        String directSource = request.get("DirectSource");
        String broadcastId = request.get("ONSbroadcastID");
        String traceRoute = request.get("TraceRoute");
        String rpcName = request.get("ONSrpcRequest");
        byte[] bodyBytes = request.body();
        if (bodyBytes != null) {
            int index;
            int bSize = 0;
            for (index = 0; index < bodyBytes.length; ++index) {
                if (bodyBytes[index] != 0) continue;
                bSize = index;
                break;
            }
            argsBytes = new byte[bSize];
            for (index = 0; index < bSize; ++index) {
                argsBytes[index] = bodyBytes[index];
            }
        } else {
            argsBytes = null;
        }
        RpcRequestListener rpcRequestListener = this.rpcRequestListeners.get(rpcName);
        RpcRequestImpl rpcRequest = new RpcRequestImpl(broadcastId, directSource, traceRoute, this.cbsubscriber.getLogicalAddress(), argsBytes, this.publisher);
        if (rpcRequestListener == null) {
            rpcRequest.sendResult("RpcRequestListener is null".getBytes(), false);
            return;
        }
        try {
            rpcRequestListener.onRequest(rpcRequest);
        }
        catch (Throwable t) {
            t.printStackTrace();
            rpcRequest.sendResult(t.toString().getBytes(), false);
        }
        if (!rpcRequest.isDone()) {
            rpcRequest.sendResult(null, true);
        }
    }
}

