/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.IllegalEnumConstantException;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.internal.categorymapping.CategoryMappingConfig;
import oracle.pgx.config.mllib.GraphWiseAttentionLayerConfig;
import oracle.pgx.config.mllib.GraphWiseBaseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseValidationConfig;
import oracle.pgx.config.mllib.inputconfig.CategoricalEmbeddingType;
import oracle.pgx.config.mllib.inputconfig.CategoricalPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.ContinuousPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.EmbeddingTableConfig;
import oracle.pgx.config.mllib.inputconfig.InputPropertyConfig;
import oracle.pgx.config.mllib.inputconfig.OneHotEncodingConfig;

public abstract class GraphWiseBaseModelConfig {
    public static final EnumSet<PropertyType> SUPPORTED_INPUT_TYPES = EnumSet.of(PropertyType.INTEGER, new PropertyType[]{PropertyType.LONG, PropertyType.FLOAT, PropertyType.DOUBLE, PropertyType.BOOLEAN, PropertyType.STRING});
    public static final int DEFAULT_BATCH_SIZE = 128;
    public static final int DEFAULT_NUM_EPOCHS = 3;
    public static final double DEFAULT_LEARNING_RATE = 0.01;
    public static final double DEFAULT_WEIGHT_DECAY = 0.0;
    public static final int DEFAULT_EMBEDDING_DIM = 128;
    public static final Integer DEFAULT_SEED = null;
    public static final Backend DEFAULT_BACKEND = Backend.TORCH;
    public static final GraphWiseBaseConvLayerConfig[] DEFAULT_CONV_LAYER_CONFIGS = new GraphWiseBaseConvLayerConfig[]{new GraphWiseConvLayerConfig(), new GraphWiseConvLayerConfig()};
    public static final boolean DEFAULT_STANDARDIZE = false;
    public static final boolean DEFAULT_NORMALIZE = true;
    public static final boolean DEFAULT_SHUFFLE = true;
    public static final boolean DEFAULT_ENABLE_ACCELERATOR = true;
    private int batchSize = 128;
    private int numEpochs = 3;
    private double learningRate = 0.01;
    private double weightDecay = 0.0;
    private int embeddingDim = 128;
    private Integer seed = DEFAULT_SEED;
    private GraphWiseBaseConvLayerConfig[] convLayerConfigs = DEFAULT_CONV_LAYER_CONFIGS;
    private GraphWiseValidationConfig validationConfig;
    private final Map<String, InputPropertyConfig> vertexInputPropertyConfigs;
    private final Map<String, InputPropertyConfig> edgeInputPropertyConfigs;
    protected CategoryMappingConfig categoryMappingConfig;
    private boolean standardize = false;
    private boolean normalize = true;
    private boolean shuffle = true;
    private Backend backend = DEFAULT_BACKEND;
    private boolean enableAccelerator = true;
    private List<String> vertexInputPropertyNames;
    private List<String> edgeInputPropertyNames;
    private boolean fitted = false;
    private double trainingLoss;
    private int vertexInputFeatureDim;
    private int edgeInputFeatureDim;

    protected GraphWiseBaseModelConfig() {
        this.vertexInputPropertyConfigs = new HashMap<String, InputPropertyConfig>();
        this.edgeInputPropertyConfigs = new HashMap<String, InputPropertyConfig>();
    }

    public GraphWiseBaseModelConfig(int batchSize, int numEpochs, double learningRate, double weightDecay, int embeddingDim, Integer seed, GraphWiseBaseConvLayerConfig[] convLayerConfigs, boolean standardize, boolean normalize, boolean shuffle, List<String> vertexInputPropertyNames, List<String> edgeInputPropertyNames, Map<String, InputPropertyConfig> vertexInputPropertyConfigs, Map<String, InputPropertyConfig> edgeInputPropertyConfigs, CategoryMappingConfig categoryMappingConfig, boolean fitted, double trainingLoss, int vertexInputFeatureDim, int edgeInputFeatureDim, Backend backend, boolean enableAccelerator, GraphWiseValidationConfig validationConfig) {
        this.batchSize = batchSize;
        this.numEpochs = numEpochs;
        this.learningRate = learningRate;
        this.weightDecay = weightDecay;
        this.embeddingDim = embeddingDim;
        this.seed = seed;
        this.convLayerConfigs = convLayerConfigs;
        this.standardize = standardize;
        this.shuffle = shuffle;
        this.vertexInputPropertyNames = vertexInputPropertyNames;
        this.edgeInputPropertyNames = edgeInputPropertyNames;
        this.vertexInputPropertyConfigs = vertexInputPropertyConfigs != null ? vertexInputPropertyConfigs : new HashMap();
        this.edgeInputPropertyConfigs = edgeInputPropertyConfigs != null ? edgeInputPropertyConfigs : new HashMap();
        this.categoryMappingConfig = categoryMappingConfig;
        this.fitted = fitted;
        this.trainingLoss = trainingLoss;
        this.vertexInputFeatureDim = vertexInputFeatureDim;
        this.edgeInputFeatureDim = edgeInputFeatureDim;
        this.backend = backend;
        this.normalize = normalize;
        this.enableAccelerator = enableAccelerator;
        this.validationConfig = validationConfig;
    }

    protected GraphWiseBaseModelConfig(GraphWiseBaseModelConfig source) {
        CategoricalEmbeddingType type;
        InputPropertyConfig otherConfig;
        String inputName;
        this.setBatchSize(source.getBatchSize());
        this.setNumEpochs(source.getNumEpochs());
        this.setLearningRate(source.getLearningRate());
        this.setEmbeddingDim(source.getEmbeddingDim());
        this.seed = source.getSeed();
        this.setFitted(source.isFitted());
        this.setShuffle(source.isShuffle());
        this.setTrainingLoss(source.getTrainingLoss());
        this.setInputFeatureDim(source.getInputFeatureDim());
        this.setEdgeInputFeatureDim(source.getEdgeInputFeatureDim());
        this.setStandardize(source.isStandardize());
        this.setNormalize(source.isNormalize());
        this.setEnableAccelerator(source.isEnableAccelerator());
        this.setValidationConfig(source.getValidationConfig());
        GraphWiseBaseConvLayerConfig[] targetLayerConfigs = source.getConvLayerConfigs();
        GraphWiseBaseConvLayerConfig[] layerConfigs = new GraphWiseBaseConvLayerConfig[targetLayerConfigs.length];
        for (int i = 0; i < targetLayerConfigs.length; ++i) {
            if (targetLayerConfigs[i] instanceof GraphWiseConvLayerConfig) {
                layerConfigs[i] = new GraphWiseConvLayerConfig((GraphWiseConvLayerConfig)targetLayerConfigs[i]);
                continue;
            }
            if (targetLayerConfigs[i] instanceof GraphWiseAttentionLayerConfig) {
                layerConfigs[i] = new GraphWiseAttentionLayerConfig((GraphWiseAttentionLayerConfig)targetLayerConfigs[i]);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of convolutional layer config type.");
        }
        this.setConvLayerConfigs(layerConfigs);
        if (source.getVertexInputPropertyNames() != null) {
            this.vertexInputPropertyNames = new ArrayList<String>(source.getVertexInputPropertyNames());
        }
        if (source.getEdgeInputPropertyNames() != null) {
            this.edgeInputPropertyNames = new ArrayList<String>(source.getEdgeInputPropertyNames());
        }
        HashMap<String, InputPropertyConfig> newVertexInputPropertyConfigs = new HashMap<String, InputPropertyConfig>();
        HashMap<String, InputPropertyConfig> newEdgeInputPropertyConfigs = new HashMap<String, InputPropertyConfig>();
        for (Map.Entry<String, InputPropertyConfig> entry : source.getVertexInputPropertyConfigs().entrySet()) {
            inputName = entry.getKey();
            otherConfig = entry.getValue();
            if (otherConfig.getCategorical()) {
                type = ((CategoricalPropertyConfig)otherConfig).getCategoricalEmbeddingType();
                switch (type) {
                    case EMBEDDING_TABLE: {
                        newVertexInputPropertyConfigs.put(inputName, new EmbeddingTableConfig((EmbeddingTableConfig)otherConfig));
                        break;
                    }
                    case ONE_HOT_ENCODING: {
                        newVertexInputPropertyConfigs.put(inputName, new OneHotEncodingConfig((OneHotEncodingConfig)otherConfig));
                        break;
                    }
                    default: {
                        throw new IllegalEnumConstantException((Enum)type);
                    }
                }
                continue;
            }
            newVertexInputPropertyConfigs.put(inputName, new ContinuousPropertyConfig((ContinuousPropertyConfig)otherConfig));
        }
        for (Map.Entry<String, InputPropertyConfig> entry : source.getEdgeInputPropertyConfigs().entrySet()) {
            inputName = entry.getKey();
            otherConfig = entry.getValue();
            if (otherConfig.getCategorical()) {
                type = ((CategoricalPropertyConfig)otherConfig).getCategoricalEmbeddingType();
                switch (type) {
                    case EMBEDDING_TABLE: {
                        newEdgeInputPropertyConfigs.put(inputName, new EmbeddingTableConfig((EmbeddingTableConfig)otherConfig));
                        break;
                    }
                    case ONE_HOT_ENCODING: {
                        newEdgeInputPropertyConfigs.put(inputName, new OneHotEncodingConfig((OneHotEncodingConfig)otherConfig));
                        break;
                    }
                    default: {
                        throw new IllegalEnumConstantException((Enum)type);
                    }
                }
                continue;
            }
            newEdgeInputPropertyConfigs.put(inputName, new ContinuousPropertyConfig((ContinuousPropertyConfig)otherConfig));
        }
        this.vertexInputPropertyConfigs = newVertexInputPropertyConfigs;
        this.edgeInputPropertyConfigs = newEdgeInputPropertyConfigs;
        if (source.getVertexInputPropertyNames() != null) {
            this.vertexInputPropertyNames = new ArrayList<String>(source.getVertexInputPropertyNames());
        }
        if (source.getEdgeInputPropertyNames() != null) {
            this.edgeInputPropertyNames = new ArrayList<String>(source.getEdgeInputPropertyNames());
        }
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public final void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public int getInputFeatureDim() {
        return this.vertexInputFeatureDim;
    }

    public final void setInputFeatureDim(int vertexInputFeatureDim) {
        this.vertexInputFeatureDim = vertexInputFeatureDim;
    }

    public int getEdgeInputFeatureDim() {
        return this.edgeInputFeatureDim;
    }

    public final void setEdgeInputFeatureDim(int edgeInputFeatureDim) {
        this.edgeInputFeatureDim = edgeInputFeatureDim;
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public final void setFitted(boolean fitted) {
        this.fitted = fitted;
    }

    public double getTrainingLoss() {
        return this.trainingLoss;
    }

    public final void setTrainingLoss(double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public final void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public final void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getWeightDecay() {
        return this.weightDecay;
    }

    public final void setWeightDecay(double weightDecay) {
        this.weightDecay = weightDecay;
    }

    public int getEmbeddingDim() {
        return this.embeddingDim;
    }

    public final void setEmbeddingDim(int embeddingDim) {
        this.embeddingDim = embeddingDim;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public final void setSeed(int seed) {
        this.seed = seed;
    }

    public GraphWiseBaseConvLayerConfig[] getConvLayerConfigs() {
        return this.convLayerConfigs;
    }

    public final void setConvLayerConfigs(GraphWiseBaseConvLayerConfig ... convLayerConfigs) {
        this.convLayerConfigs = convLayerConfigs;
    }

    public GraphWiseValidationConfig getValidationConfig() {
        return this.validationConfig;
    }

    public final void setValidationConfig(GraphWiseValidationConfig validationConfig) {
        this.validationConfig = validationConfig;
    }

    public Map<String, InputPropertyConfig> getVertexInputPropertyConfigs() {
        return this.vertexInputPropertyConfigs;
    }

    public Map<String, InputPropertyConfig> getEdgeInputPropertyConfigs() {
        return this.edgeInputPropertyConfigs;
    }

    public final void setVertexInputPropertyConfigs(InputPropertyConfig ... vertexInputPropertyConfigs) {
        this.vertexInputPropertyConfigs.clear();
        for (InputPropertyConfig inputPropertyConfig : vertexInputPropertyConfigs) {
            this.vertexInputPropertyConfigs.put(inputPropertyConfig.getPropertyName(), inputPropertyConfig);
        }
    }

    public final void setEdgeInputPropertyConfigs(InputPropertyConfig ... edgeInputPropertyConfigs) {
        this.edgeInputPropertyConfigs.clear();
        for (InputPropertyConfig inputPropertyConfig : edgeInputPropertyConfigs) {
            this.edgeInputPropertyConfigs.put(inputPropertyConfig.getPropertyName(), inputPropertyConfig);
        }
    }

    public CategoryMappingConfig getCategoryMappingConfig() {
        return this.categoryMappingConfig;
    }

    public final void setCategoryMappingConfig(CategoryMappingConfig categoryMappingConfig) {
        this.categoryMappingConfig = categoryMappingConfig;
    }

    public final void clearSensitiveData() {
        this.categoryMappingConfig = null;
    }

    public List<String> getVertexInputPropertyNames() {
        return this.vertexInputPropertyNames;
    }

    public final void setVertexInputPropertyNames(List<String> vertexInputPropertyNames) {
        this.vertexInputPropertyNames = vertexInputPropertyNames;
    }

    public List<String> getEdgeInputPropertyNames() {
        return this.edgeInputPropertyNames;
    }

    public final void setEdgeInputPropertyNames(List<String> edgeInputPropertyNames) {
        this.edgeInputPropertyNames = edgeInputPropertyNames;
    }

    public boolean isStandardize() {
        return this.standardize;
    }

    public final void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public final void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public void setEnableAccelerator(boolean enableAccelerator) {
        this.enableAccelerator = enableAccelerator;
    }

    public boolean isEnableAccelerator() {
        return this.enableAccelerator;
    }

    public static enum Backend {
        TORCH;

    }
}

