/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class PgqlOption {
    public static List<PgqlOption> getClientPgqlOptionsWithDefaults(List<PgqlOption> pgqlOptions) {
        boolean containsLazyEvaluationOption;
        if (pgqlOptions == null) {
            pgqlOptions = Collections.emptyList();
        }
        boolean containsSchemaStrictnessOption = pgqlOptions.stream().anyMatch(option -> option instanceof PgqlSchemaStrictnessOption);
        ArrayList<PgqlOption> finalOptions = new ArrayList<PgqlOption>(pgqlOptions);
        if (!containsSchemaStrictnessOption) {
            finalOptions.add(PgqlSchemaStrictnessOption.PGQL_STRICT_SCHEMA_MODE);
        }
        if (!(containsLazyEvaluationOption = pgqlOptions.stream().anyMatch(option -> option instanceof PgqlLazyResultSetEvaluationOption))) {
            finalOptions.add(PgqlLazyResultSetEvaluationOption.PGQL_NON_LAZY_EVALUATION_MODE);
        }
        return finalOptions;
    }

    public static List<PgqlOption> getClientPgqlOptionsNoDefaults(List<PgqlOption> pgqlOptions) {
        if (pgqlOptions == null) {
            pgqlOptions = Collections.emptyList();
        }
        return pgqlOptions;
    }

    public static class PgqlLazyResultSetEvaluationOption
    extends PgqlOption {
        public static final PgqlLazyResultSetEvaluationOption PGQL_LAZY_EVALUATION_MODE = new PgqlLazyResultSetEvaluationOption(true);
        public static final PgqlLazyResultSetEvaluationOption PGQL_NON_LAZY_EVALUATION_MODE = new PgqlLazyResultSetEvaluationOption(false);
        private boolean lazyEvaluationMode;

        public PgqlLazyResultSetEvaluationOption(boolean lazyEvaluationMode) {
            this.lazyEvaluationMode = lazyEvaluationMode;
        }

        public boolean isLazyEvaluationMode() {
            return this.lazyEvaluationMode;
        }

        public void setLazyEvaluationMode(boolean lazyEvaluationMode) {
            this.lazyEvaluationMode = lazyEvaluationMode;
        }

        public String toString() {
            return "PgqlLazyResultSetEvaluationOption: " + this.lazyEvaluationMode;
        }
    }

    public static class PgqlPropertiesRedactionOnlyOption
    extends PgqlOption {
        public static final PgqlPropertiesRedactionOnlyOption PGQL_PROPERTIES_REDACTION_ONLY_MODE = new PgqlPropertiesRedactionOnlyOption(true);
        private final boolean propertiesRedactionOnly;

        public PgqlPropertiesRedactionOnlyOption(boolean propertiesRedactionOnly) {
            this.propertiesRedactionOnly = propertiesRedactionOnly;
        }

        public String toString() {
            return "PgqlPropertiesRedactionOnlyOption: " + this.propertiesRedactionOnly;
        }
    }

    public static class PgqlRedactionFreeOption
    extends PgqlOption {
        public static final PgqlRedactionFreeOption PGQL_REDACTION_FREE_MODE = new PgqlRedactionFreeOption(true);
        private final boolean isRedactionFree;

        public PgqlRedactionFreeOption(boolean isRedactionFree) {
            this.isRedactionFree = isRedactionFree;
        }

        public String toString() {
            return "PgqlRedactionFreeOption: " + this.isRedactionFree;
        }
    }

    public static class PgqlSchemaStrictnessOption
    extends PgqlOption {
        public static final PgqlSchemaStrictnessOption PGQL_STRICT_SCHEMA_MODE = new PgqlSchemaStrictnessOption(true);
        public static final PgqlSchemaStrictnessOption PGQL_LOOSE_SCHEMA_MODE = new PgqlSchemaStrictnessOption(false);
        private boolean strictSchemaMode;

        public PgqlSchemaStrictnessOption(boolean strictSchemaMode) {
            this.strictSchemaMode = strictSchemaMode;
        }

        public boolean isStrictSchemaMode() {
            return this.strictSchemaMode;
        }

        public void setStrictSchemaMode(boolean strictSchemaMode) {
            this.strictSchemaMode = strictSchemaMode;
        }

        public String toString() {
            return "PgqlSchemaStrictnessOption: " + this.strictSchemaMode;
        }
    }
}

