/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.RealmConfig;

public final class RealmConfigBuilder {
    private final Map<RealmConfig.Field, Object> values = new HashMap<RealmConfig.Field, Object>();

    public static RealmConfig buildRealmConfig(Consumer<RealmConfigBuilder> builderSetup) {
        RealmConfigBuilder builder = new RealmConfigBuilder();
        builderSetup.accept(builder);
        return builder.build();
    }

    public RealmConfigBuilder() {
    }

    public RealmConfigBuilder(Map<RealmConfig.Field, Object> values) {
        this.putAll(values);
    }

    public RealmConfigBuilder(RealmConfig config) {
        this.putAll(config);
    }

    public RealmConfigBuilder(RealmConfigBuilder builder) {
        this.putAll(builder.values);
    }

    public RealmConfigBuilder putAll(Map<RealmConfig.Field, Object> values) {
        this.values.putAll(values);
        return this;
    }

    public RealmConfigBuilder putAll(RealmConfig config) {
        this.putAll(config.getValuesWithoutDefaults());
        return this;
    }

    public RealmConfigBuilder clear() {
        this.values.clear();
        return this;
    }

    public RealmConfig build(String parentPath) {
        try {
            return RealmConfig.parse(this.toInputStream(), true, parentPath);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public RealmConfig build() {
        return this.build(null);
    }

    public InputStream toInputStream() {
        try {
            return ConfigJsonUtil.toJsonInputStream(this.values);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public Map<RealmConfig.Field, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return "RealmConfigBuilder" + this.values;
    }

    public RealmConfigBuilder setImplementation(String implementation) {
        this.values.put(RealmConfig.Field.IMPLEMENTATION, implementation);
        return this;
    }

    public RealmConfigBuilder setOptions(Object options) {
        this.values.put(RealmConfig.Field.OPTIONS, options);
        return this;
    }
}

