/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import oracle.pgx.api.filter.EdgeFilter;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.config.FilterExpressionConfig;

public class GraphFilterFactory {
    private GraphFilterFactory() {
    }

    public static GraphFilter createFromFilterExpressionConfig(FilterExpressionConfig filterConfig) {
        if (filterConfig.isEmpty()) {
            throw new IllegalArgumentException();
        }
        switch (filterConfig.getType()) {
            case EDGE: {
                return new EdgeFilter(filterConfig.getExpression());
            }
            case VERTEX: {
                return new VertexFilter(filterConfig.getExpression());
            }
            case UNION: 
            case INTERSECTION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalArgumentException();
    }
}

