/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.IOException;
import java.util.Map;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractEntityProviderConfigFactory;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.EsEntityProviderConfigFactory;
import oracle.pgx.config.FileEntityProviderConfig;
import oracle.pgx.config.FileEntityProviderConfigFactory;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.config.RdbmsEntityProviderConfigFactory;

public class AnyFormatEntityProviderConfigFactory
extends AbstractEntityProviderConfigFactory<EntityProviderConfig> {
    private static boolean strictMode = (Boolean)PgxConfig.Field.STRICT_MODE.getDefaultVal();
    private final boolean strict;

    public AnyFormatEntityProviderConfigFactory() {
        this(strictMode);
    }

    public AnyFormatEntityProviderConfigFactory(boolean strict) {
        this.strict = strict;
    }

    public AnyFormatEntityProviderConfigFactory(boolean strict, boolean parseHiddenValues) {
        super(parseHiddenValues);
        this.strict = strict;
    }

    @Override
    protected boolean supports(ProviderFormat format) {
        return true;
    }

    @Override
    protected EntityProviderConfig fromMap(Map<String, Object> raw, String parentPath) throws IOException {
        Object formatObj = raw.get(FileEntityProviderConfig.Field.FORMAT.toKey());
        if (formatObj == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"TABLE_FORMAT_NOT_FOUND", (Object[])new Object[]{raw.get(FileEntityProviderConfig.Field.NAME.toKey())}));
        }
        return (EntityProviderConfig)this.createFactory(formatObj.toString()).fromMap(raw, parentPath);
    }

    private AbstractEntityProviderConfigFactory<? extends EntityProviderConfig> createFactory(String formatStr) {
        ProviderFormat format = ProviderFormat.valueOf(formatStr.toUpperCase());
        switch (format) {
            case PGB: 
            case CSV: {
                return new FileEntityProviderConfigFactory(this.strict, this.parseHiddenValues);
            }
            case RDBMS: {
                return new RdbmsEntityProviderConfigFactory(this.strict, this.parseHiddenValues);
            }
            case ES: {
                return new EsEntityProviderConfigFactory(this.strict, this.parseHiddenValues);
            }
        }
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_FORMAT", (Object[])new Object[]{format}));
    }

    @Override
    protected void addDefaultIdTypeIfMissing(Map<String, Object> raw) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addDefaultCreateIndexMappingIfMissing(Map<String, Object> raw) {
        throw new UnsupportedOperationException();
    }
}

