/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Arrays;
import java.util.Collection;
import oracle.pgx.common.auth.PgxResourcePermission;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.PgxConfigPermission;

public abstract class AbstractAuthorizationEntityPermissionConfig
extends AbstractConfig {
    abstract PgxConfigPermission getGrant();

    abstract String getFileLocation();

    abstract String getPreloadedGraph();

    final PgxResourcePermission getPermission() {
        return this.getGrant().toObjectPermission();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getFileLocation() != null) {
            this.checkPermissionIsValid("file-locations", Arrays.asList(PgxConfigPermission.READ, PgxConfigPermission.WRITE));
        } else if (this.getPreloadedGraph() != null) {
            this.checkPermissionIsValid("preloaded-graphs", Arrays.asList(PgxConfigPermission.READ, PgxConfigPermission.EXPORT, PgxConfigPermission.MANAGE));
        } else {
            this.checkPermissionIsValid("general", Arrays.asList(PgxConfigPermission.PGX_SESSION_CREATE, PgxConfigPermission.PGX_SESSION_NEW_GRAPH, PgxConfigPermission.PGX_SESSION_GET_PUBLISHED_GRAPH, PgxConfigPermission.PGX_SESSION_ADD_PUBLISHED_GRAPH, PgxConfigPermission.PGX_SESSION_COMPILE_ALGORITHM, PgxConfigPermission.PGX_SERVER_GET_INFO, PgxConfigPermission.PGX_SERVER_MANAGE, PgxConfigPermission.PGX_SESSION_READ_MODEL, PgxConfigPermission.PGX_SESSION_MODIFY_MODEL));
        }
    }

    private void checkPermissionIsValid(String type, Collection<PgxConfigPermission> validPermissions) {
        if (!validPermissions.contains((Object)this.getGrant())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_PERMISSION", (Object[])new Object[]{this.getGrant(), type.toLowerCase()}));
        }
    }
}

