/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.InvalidChangeHandler;

public class EntityIdConversionHelper
extends ConversionHelper {
    private static boolean canConvertVertexIdToInt(Object id) {
        if (id instanceof Integer) {
            return true;
        }
        if (id instanceof Long) {
            return EntityIdConversionHelper.canConvertLongToInteger((Long)id);
        }
        if (id instanceof String) {
            return EntityIdConversionHelper.canConvertStringToInteger((String)id);
        }
        return false;
    }

    private static boolean canConvertVertexIdToLong(Object id) {
        if (id instanceof Integer || id instanceof Long) {
            return true;
        }
        if (id instanceof String) {
            return EntityIdConversionHelper.canConvertStringToLong((String)id);
        }
        return false;
    }

    private static boolean canConvertVertexIdToString(Object id) {
        return id instanceof String || id instanceof Integer || id instanceof Long;
    }

    public static boolean canConvertVertexId(IdType targtetIdType, Object id) {
        switch (targtetIdType) {
            case INTEGER: {
                return EntityIdConversionHelper.canConvertVertexIdToInt(id);
            }
            case LONG: {
                return EntityIdConversionHelper.canConvertVertexIdToLong(id);
            }
            case STRING: {
                return EntityIdConversionHelper.canConvertVertexIdToString(id);
            }
        }
        return false;
    }

    public static <VID> VID toVertexId(IdType currentIdType, Object object) {
        return EntityIdConversionHelper.toVertexIdAndLogIfNecessary(currentIdType, object, null, InvalidChangeHandler.VertexLocation.UNSPECIFIED);
    }

    public static <VID> VID toVertexIdAndLogIfNecessary(IdType currentIdType, Object object, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        ErrorMessages.requireNonNull((Object)object, (String)"object");
        switch (currentIdType) {
            case INTEGER: {
                return (VID)Integer.valueOf(EntityIdConversionHelper.toIntVertexIdAndLogIfNecessary(object, invalidChangeHandler, vertexLocation));
            }
            case LONG: {
                return (VID)Long.valueOf(EntityIdConversionHelper.toLongVertexIdAndLogIfNecessary(object, invalidChangeHandler, vertexLocation));
            }
            case STRING: {
                return (VID)EntityIdConversionHelper.toStringVertexIdAndLogIfNecessary(object, invalidChangeHandler, vertexLocation);
            }
        }
        throw new IllegalArgumentException("Invalid IdType " + currentIdType);
    }

    public static int toIntVertexIdAndLogIfNecessary(Object object, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        return EntityIdConversionHelper.toIntIdAndLogIfNecessary(object, "NODE_ID_UNEXPECTED_TYPE", invalidChangeHandler, vertexLocation);
    }

    public static long toLongVertexIdAndLogIfNecessary(Object object, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        return EntityIdConversionHelper.toLongIdAndLogIfNecessary(object, "NODE_ID_UNEXPECTED_TYPE", invalidChangeHandler, vertexLocation);
    }

    public static String toStringVertexIdAndLogIfNecessary(Object object, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        return EntityIdConversionHelper.toStringIdAndLogIfNecessary(object, "NODE_ID_UNEXPECTED_TYPE", invalidChangeHandler, vertexLocation);
    }

    public static long toLongEdgeIdAndLogIfNecessary(Object object, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        return EntityIdConversionHelper.toLongIdAndLogIfNecessary(object, "EDGE_ID_UNEXPECTED_TYPE", invalidChangeHandler, vertexLocation);
    }

    public static int toIntId(Object object, String messageKey) {
        return EntityIdConversionHelper.toIntIdAndLogIfNecessary(object, messageKey, null, InvalidChangeHandler.VertexLocation.UNSPECIFIED);
    }

    public static int toIntIdAndLogIfNecessary(Object object, String messageKey, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Long) {
            return Math.toIntExact((Long)object);
        }
        if (object instanceof String) {
            if (invalidChangeHandler != null) {
                invalidChangeHandler.handleVertexIdConversion(IdType.getTypeFor(String.class), IdType.getTypeFor(Integer.class), vertexLocation);
            }
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_ID_UNKNOWN_TYPE", (Object[])new Object[]{IdType.getTypeFor(Integer.class)}));
    }

    public static long toLongId(Object object, String messageKey) {
        return EntityIdConversionHelper.toLongIdAndLogIfNecessary(object, messageKey, null, InvalidChangeHandler.VertexLocation.UNSPECIFIED);
    }

    public static long toLongIdAndLogIfNecessary(Object object, String messageKey, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            if (invalidChangeHandler != null) {
                invalidChangeHandler.handleVertexIdConversion(IdType.getTypeFor(String.class), IdType.getTypeFor(Long.class), vertexLocation);
            }
            return Long.parseLong((String)object);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_ID_UNKNOWN_TYPE", (Object[])new Object[]{IdType.getTypeFor(Long.class)}));
    }

    public static String toStringId(Object object, String messageKey) {
        return EntityIdConversionHelper.toStringIdAndLogIfNecessary(object, messageKey, null, InvalidChangeHandler.VertexLocation.UNSPECIFIED);
    }

    public static String toStringIdAndLogIfNecessary(Object object, String messageKey, InvalidChangeHandler invalidChangeHandler, InvalidChangeHandler.VertexLocation vertexLocation) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            if (invalidChangeHandler != null) {
                invalidChangeHandler.handleVertexIdConversion(IdType.getTypeFor(Integer.class), IdType.getTypeFor(String.class), vertexLocation);
            }
            return String.valueOf((Integer)object);
        }
        if (object instanceof Long) {
            if (invalidChangeHandler != null) {
                invalidChangeHandler.handleVertexIdConversion(IdType.getTypeFor(Long.class), IdType.getTypeFor(String.class), vertexLocation);
            }
            return String.valueOf((Long)object);
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"NODE_ID_UNKNOWN_TYPE", (Object[])new Object[]{IdType.getTypeFor(String.class)}));
    }
}

