/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import java.util.concurrent.TimeUnit;
import oracle.pgx.common.MemoryUnit;
import oracle.pgx.common.types.IdType;

public class ConversionHelper {
    public static int toSeconds(long ms) {
        return (int)TimeUnit.SECONDS.convert(ms, TimeUnit.MILLISECONDS);
    }

    public static double toMB(long bytes) {
        return MemoryUnit.BYTE.convertToFraction((double)bytes, MemoryUnit.MEGABYTE);
    }

    public static <VID> VID tryCastIntegerToLong(VID id, IdType expectedType) {
        if (expectedType == IdType.LONG && id instanceof Integer) {
            Integer intId = (Integer)id;
            Long value = (long)intId;
            return (VID)value;
        }
        return id;
    }

    public static boolean canConvertStringToInteger(String str) {
        try {
            int intValue = Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canConvertStringToLong(String str) {
        try {
            long longValue = Long.parseLong(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canConvertLongToInteger(long value) {
        try {
            int intValue = Math.toIntExact(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

