/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import oracle.pgx.config.mllib.GraphWiseConvLayerConfig;
import oracle.pgx.config.mllib.GraphWiseDgiLayerConfig;
import oracle.pgx.config.mllib.GraphWiseModelConfig;

public class UnsupervisedGraphWiseModelConfig
extends GraphWiseModelConfig {
    public static final LossFunction DEFAULT_LOSS_FUNCTION = LossFunction.SIGMOID_CROSS_ENTROPY;
    public static final GraphWiseDgiLayerConfig DEFAULT_DGI_LAYER_CONFIG = new GraphWiseDgiLayerConfig();
    private LossFunction lossFunction = DEFAULT_LOSS_FUNCTION;
    private GraphWiseDgiLayerConfig dgiLayerConfig = DEFAULT_DGI_LAYER_CONFIG;

    public UnsupervisedGraphWiseModelConfig() {
    }

    @JsonCreator
    public UnsupervisedGraphWiseModelConfig(@JsonProperty(required=true, value="batchSize") int batchSize, @JsonProperty(required=true, value="numEpochs") int numEpochs, @JsonProperty(required=true, value="learningRate") double learningRate, @JsonProperty(required=false, value="weightDecay") double weightDecay, @JsonProperty(required=true, value="embeddingDim") int embeddingDim, @JsonProperty(required=true, value="seed") Integer seed, @JsonProperty(required=true, value="convLayerConfigs") GraphWiseConvLayerConfig[] convLayerConfigs, @JsonProperty(required=true, value="standardize") boolean standardize, @JsonProperty(required=true, value="shuffle") boolean shuffle, @JsonProperty(required=true, value="vertexInputPropertyNames") List<String> vertexInputPropertyNames, @JsonProperty(required=false, value="edgeInputPropertyNames") List<String> edgeInputPropertyNames, @JsonProperty(required=false, value="targetVertexLabelSets") List<Set<String>> targetVertexLabels, @JsonProperty(required=true, value="fitted") boolean fitted, @JsonProperty(required=true, value="trainingLoss") double trainingLoss, @JsonProperty(required=true, value="inputFeatureDim") int inputFeatureDim, @JsonProperty(required=false, value="inputEdgeFeatureDim") int inputEdgeFeatureDim, @JsonProperty(required=true, value="lossFunction") LossFunction lossFunction, @JsonProperty(required=true, value="dgiLayerConfig") GraphWiseDgiLayerConfig dgiLayerConfig, @JsonProperty(required=true, value="backend") GraphWiseModelConfig.Backend backend, @JsonProperty(required=false, value="variant") GraphWiseModelConfig.GraphConvModelVariant variant) {
        super(batchSize, numEpochs, learningRate, weightDecay, embeddingDim, seed, convLayerConfigs, standardize, shuffle, vertexInputPropertyNames, edgeInputPropertyNames, fitted, trainingLoss, inputFeatureDim, inputEdgeFeatureDim, targetVertexLabels, backend, variant);
        this.lossFunction = lossFunction;
        this.dgiLayerConfig = dgiLayerConfig;
    }

    public UnsupervisedGraphWiseModelConfig(UnsupervisedGraphWiseModelConfig source) {
        super(source);
        this.setLossFunction(source.getLossFunction());
        this.setDgiLayerConfig(source.getDgiLayerConfig());
    }

    public GraphWiseDgiLayerConfig getDgiLayerConfig() {
        return this.dgiLayerConfig;
    }

    public final void setDgiLayerConfig(GraphWiseDgiLayerConfig dgiLayerConfig) {
        this.dgiLayerConfig = dgiLayerConfig;
    }

    public LossFunction getLossFunction() {
        return this.lossFunction;
    }

    public final void setLossFunction(LossFunction lossFunction) {
        this.lossFunction = lossFunction;
    }

    public static enum LossFunction {
        SIGMOID_CROSS_ENTROPY;

    }
}

