/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config.mllib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.mllib.GraphWiseConvLayerConfig;

public abstract class GraphWiseModelConfig {
    public static final EnumSet<PropertyType> SUPPORTED_INPUT_TYPES = EnumSet.of(PropertyType.INTEGER, PropertyType.LONG, PropertyType.FLOAT, PropertyType.DOUBLE, PropertyType.BOOLEAN);
    public static final int DEFAULT_BATCH_SIZE = 128;
    public static final int DEFAULT_NUM_EPOCHS = 3;
    public static final double DEFAULT_LEARNING_RATE = 0.01;
    public static final double DEFAULT_WEIGHT_DECAY = 0.0;
    public static final int DEFAULT_EMBEDDING_DIM = 128;
    public static final Integer DEFAULT_SEED = null;
    public static final Backend DEFAULT_BACKEND = Backend.TORCH;
    public static final GraphConvModelVariant DEFAULT_MODE = null;
    public static final GraphWiseConvLayerConfig[] DEFAULT_CONV_LAYER_CONFIGS = new GraphWiseConvLayerConfig[]{new GraphWiseConvLayerConfig(), new GraphWiseConvLayerConfig()};
    public static final boolean DEFAULT_STANDARDIZE = false;
    public static final boolean DEFAULT_SHUFFLE = true;
    private int batchSize = 128;
    private int numEpochs = 3;
    private double learningRate = 0.01;
    private double weightDecay = 0.0;
    private int embeddingDim = 128;
    private Integer seed = DEFAULT_SEED;
    private GraphWiseConvLayerConfig[] convLayerConfigs = DEFAULT_CONV_LAYER_CONFIGS;
    private boolean standardize = false;
    private boolean shuffle = true;
    private Backend backend = DEFAULT_BACKEND;
    private GraphConvModelVariant variant = DEFAULT_MODE;
    private List<String> vertexInputPropertyNames;
    private List<String> edgeInputPropertyNames;
    private List<Set<String>> targetVertexLabelSets;
    private boolean fitted = false;
    private double trainingLoss;
    private int vertexInputFeatureDim;
    private int edgeInputFeatureDim;

    GraphWiseModelConfig() {
    }

    public GraphWiseModelConfig(int batchSize, int numEpochs, double learningRate, double weightDecay, int embeddingDim, Integer seed, GraphWiseConvLayerConfig[] convLayerConfigs, boolean standardize, boolean shuffle, List<String> vertexInputPropertyNames, List<String> edgeInputPropertyNames, boolean fitted, double trainingLoss, int vertexInputFeatureDim, int edgeInputFeatureDim, List<Set<String>> targetVertexLabelSets, Backend backend, GraphConvModelVariant variant) {
        this.batchSize = batchSize;
        this.numEpochs = numEpochs;
        this.learningRate = learningRate;
        this.weightDecay = weightDecay;
        this.embeddingDim = embeddingDim;
        this.seed = seed;
        this.convLayerConfigs = convLayerConfigs;
        this.standardize = standardize;
        this.shuffle = shuffle;
        this.vertexInputPropertyNames = vertexInputPropertyNames;
        this.edgeInputPropertyNames = edgeInputPropertyNames;
        this.fitted = fitted;
        this.trainingLoss = trainingLoss;
        this.vertexInputFeatureDim = vertexInputFeatureDim;
        this.edgeInputFeatureDim = edgeInputFeatureDim;
        this.targetVertexLabelSets = targetVertexLabelSets;
        this.backend = backend;
        this.variant = variant;
    }

    GraphWiseModelConfig(GraphWiseModelConfig source) {
        this.setBatchSize(source.getBatchSize());
        this.setNumEpochs(source.getNumEpochs());
        this.setLearningRate(source.getLearningRate());
        this.setEmbeddingDim(source.getEmbeddingDim());
        this.seed = source.getSeed();
        this.setFitted(source.isFitted());
        this.setShuffle(source.isShuffle());
        this.setTrainingLoss(source.getTrainingLoss());
        this.setInputFeatureDim(source.getInputFeatureDim());
        this.setEdgeInputFeatureDim(source.getEdgeInputFeatureDim());
        this.setTargetVertexLabelSets(source.getTargetVertexLabelSets());
        this.setStandardize(source.isStandardize());
        this.variant = source.getVariant();
        GraphWiseConvLayerConfig[] targetLayerConfigs = source.getConvLayerConfigs();
        GraphWiseConvLayerConfig[] layerConfigs = new GraphWiseConvLayerConfig[targetLayerConfigs.length];
        for (int i = 0; i < targetLayerConfigs.length; ++i) {
            layerConfigs[i] = new GraphWiseConvLayerConfig();
            layerConfigs[i].setNumSampledNeighbors(targetLayerConfigs[i].getNumSampledNeighbors());
            layerConfigs[i].setWeightedAggregationProperty(targetLayerConfigs[i].getNeighborWeightPropertyName());
            layerConfigs[i].setActivationFunction(targetLayerConfigs[i].getActivationFunction());
            layerConfigs[i].setWeightInitScheme(targetLayerConfigs[i].getWeightInitScheme());
            boolean enableVertexToVertexConnection = targetLayerConfigs[i].getVertexToVertexConnection() == null ? true : targetLayerConfigs[i].getVertexToVertexConnection();
            boolean enableEdgeToVertexConnection = targetLayerConfigs[i].getEdgeToVertexConnection() != null && targetLayerConfigs[i].getEdgeToVertexConnection() != false;
            boolean enableVertexToEdgeConnection = targetLayerConfigs[i].getVertexToEdgeConnection() != null && targetLayerConfigs[i].getVertexToEdgeConnection() != false;
            boolean enableEdgeToEdgeConnection = targetLayerConfigs[i].getEdgeToEdgeConnection() != null && targetLayerConfigs[i].getEdgeToEdgeConnection() != false;
            layerConfigs[i].useVertexToVertexConnection(enableVertexToVertexConnection);
            layerConfigs[i].useVertexToEdgeConnection(enableVertexToEdgeConnection);
            layerConfigs[i].useEdgeToVertexConnection(enableEdgeToVertexConnection);
            layerConfigs[i].useEdgeToEdgeConnection(enableEdgeToEdgeConnection);
        }
        this.setConvLayerConfigs(layerConfigs);
        if (source.getVertexInputPropertyNames() != null) {
            this.vertexInputPropertyNames = new ArrayList<String>(source.getVertexInputPropertyNames());
        }
        if (source.getEdgeInputPropertyNames() != null) {
            this.edgeInputPropertyNames = new ArrayList<String>(source.getEdgeInputPropertyNames());
        }
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public final void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public int getInputFeatureDim() {
        return this.vertexInputFeatureDim;
    }

    public final void setInputFeatureDim(int vertexInputFeatureDim) {
        this.vertexInputFeatureDim = vertexInputFeatureDim;
    }

    public int getEdgeInputFeatureDim() {
        return this.edgeInputFeatureDim;
    }

    public final void setEdgeInputFeatureDim(int edgeInputFeatureDim) {
        this.edgeInputFeatureDim = edgeInputFeatureDim;
    }

    public boolean isFitted() {
        return this.fitted;
    }

    public final void setFitted(boolean fitted) {
        this.fitted = fitted;
    }

    public double getTrainingLoss() {
        return this.trainingLoss;
    }

    public final void setTrainingLoss(double trainingLoss) {
        this.trainingLoss = trainingLoss;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public final void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public final void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public final void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getWeightDecay() {
        return this.weightDecay;
    }

    public final void setWeightDecay(double weightDecay) {
        this.weightDecay = weightDecay;
    }

    public int getEmbeddingDim() {
        return this.embeddingDim;
    }

    public final void setEmbeddingDim(int embeddingDim) {
        this.embeddingDim = embeddingDim;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public final void setSeed(int seed) {
        this.seed = seed;
    }

    public GraphWiseConvLayerConfig[] getConvLayerConfigs() {
        return this.convLayerConfigs;
    }

    public final void setConvLayerConfigs(GraphWiseConvLayerConfig ... convLayerConfigs) {
        this.convLayerConfigs = convLayerConfigs;
    }

    public List<String> getVertexInputPropertyNames() {
        return this.vertexInputPropertyNames;
    }

    public final void setVertexInputPropertyNames(List<String> vertexInputPropertyNames) {
        this.vertexInputPropertyNames = vertexInputPropertyNames;
    }

    public List<String> getEdgeInputPropertyNames() {
        return this.edgeInputPropertyNames;
    }

    public final void setEdgeInputPropertyNames(List<String> edgeInputPropertyNames) {
        this.edgeInputPropertyNames = edgeInputPropertyNames;
    }

    public List<Set<String>> getTargetVertexLabelSets() {
        return this.targetVertexLabelSets;
    }

    public final void setTargetVertexLabelSets(List<Set<String>> targetVertexLabelSets) {
        this.targetVertexLabelSets = targetVertexLabelSets;
    }

    public void setTargetVertexLabels(List<String> targetVertexLabels) {
        this.targetVertexLabelSets = GraphWiseModelConfig.listOfStringsToListOfSetOfStrings(targetVertexLabels);
    }

    public boolean isStandardize() {
        return this.standardize;
    }

    public final void setStandardize(boolean standardize) {
        this.standardize = standardize;
    }

    public Backend getBackend() {
        return this.backend;
    }

    public final void setVariant(GraphConvModelVariant variant) {
        if (this.variant != null) {
            throw new IllegalStateException(ErrorMessages.getMessage((String)"IMMUTABLE_GRAPHWISE_VARIANT", (Object[])new Object[0]));
        }
        this.variant = variant;
    }

    public GraphConvModelVariant getVariant() {
        return this.variant;
    }

    private static List<Set<String>> listOfStringsToListOfSetOfStrings(List<String> targetVertexLabels) {
        return targetVertexLabels.stream().map(label -> new HashSet<String>(Collections.singletonList(label))).collect(Collectors.toList());
    }

    public static enum GraphConvModelVariant {
        GRAPHWISE,
        INTERTWINED;

    }

    public static enum Backend {
        TORCH;

    }
}

