/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.Format;
import oracle.pgx.config.RdfGraphConfig;
import oracle.pgx.config.RdfGraphConfigFactory;
import oracle.pgx.config.RdfGraphPrefixConfig;

public final class RdfGraphConfigBuilder
extends AbstractGraphConfigBuilder<RdfGraphConfigBuilder, RdfGraphConfig> {
    private final List<String> vertexLabelPredicates = new LinkedList<String>();
    private final List<String> ignoredPredicates = new LinkedList<String>();
    private final List<String> acceptedPredicates = new LinkedList<String>();
    private final List<Map<String, Object>> prefixes = new LinkedList<Map<String, Object>>();

    public static RdfGraphConfigBuilder forFormat(Format format) {
        return new RdfGraphConfigBuilder().setFormat(format);
    }

    public RdfGraphConfigBuilder() {
        this.values.put(RdfGraphConfig.Field.VERTEX_LABEL_PREDICATES.toKey(), this.vertexLabelPredicates);
        this.values.put(RdfGraphConfig.Field.IGNORED_PREDICATES.toKey(), this.ignoredPredicates);
        this.values.put(RdfGraphConfig.Field.ACCEPTED_PREDICATES.toKey(), this.acceptedPredicates);
        this.values.put(RdfGraphConfig.Field.PREFIXES.toKey(), this.prefixes);
        this.values.put(RdfGraphConfig.Field.FORMAT.toKey(), Format.RDF);
        this.setVertexIdType(IdType.STRING);
    }

    @Override
    protected AbstractGraphConfigFactory<RdfGraphConfig> getFactory() {
        return new RdfGraphConfigFactory(true, true);
    }

    @Override
    public RdfGraphConfigBuilder copyFrom(RdfGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setPassword((String)graphConfig.getValues().get(RdfGraphConfig.Field.PASSWORD));
        this.setVertexIdType(graphConfig.getVertexIdType());
        this.setName(graphConfig.getName());
        this.vertexLabelPredicates.addAll(graphConfig.getVertexLabelPredicates());
        this.ignoredPredicates.addAll(graphConfig.getIgnoredPredicates());
        this.acceptedPredicates.addAll(graphConfig.getAcceptedPredicates());
        graphConfig.getPrefixes().forEach(prefixConfig -> this.addPrefix(prefixConfig.getPrefix(), prefixConfig.getValue()));
        return (RdfGraphConfigBuilder)this.getThis();
    }

    @Override
    public RdfGraphConfigBuilder setVertexIdType(IdType vertexIdType) {
        if (vertexIdType != IdType.LONG && vertexIdType != IdType.STRING) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{vertexIdType}));
        }
        return (RdfGraphConfigBuilder)super.setVertexIdType(vertexIdType);
    }

    public RdfGraphConfigBuilder setFormat(Format format) {
        if (format != Format.RDF) {
            throw new IllegalArgumentException("Only " + Format.RDF.toString() + "is supported.");
        }
        this.values.put(RdfGraphConfig.Field.FORMAT.toKey(), format);
        return this;
    }

    public RdfGraphConfigBuilder setDataSourceId(String dataSourceId) {
        this.values.put(RdfGraphConfig.Field.DATA_SOURCE_ID.toKey(), dataSourceId);
        return this;
    }

    public RdfGraphConfigBuilder setJdbcUrl(String url) {
        this.values.put(RdfGraphConfig.Field.JDBC_URL.toKey(), url);
        return this;
    }

    public RdfGraphConfigBuilder setUsername(String un) {
        this.values.put(RdfGraphConfig.Field.USERNAME.toKey(), un);
        return this;
    }

    public RdfGraphConfigBuilder setName(String model) {
        this.values.put(RdfGraphConfig.Field.NAME.toKey(), model);
        return this;
    }

    public RdfGraphConfigBuilder addVertexLabelPredicate(String predicate) {
        this.vertexLabelPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addIgnoredPredicate(String predicate) {
        this.ignoredPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addAcceptedPredicate(String predicate) {
        this.acceptedPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addPrefix(String name, String value) {
        HashMap<String, String> alias = new HashMap<String, String>();
        alias.put(RdfGraphPrefixConfig.Field.PREFIX.toKey(), name);
        alias.put(RdfGraphPrefixConfig.Field.VALUE.toKey(), value);
        this.prefixes.add(alias);
        return this;
    }
}

