/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import oracle.pgx.common.util.ConfigJsonUtil;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.OnMismatch;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.ParseResult;
import oracle.pgx.config.PropertiesConfigParser;

public class GraphErrorHandlingConfig
extends AbstractConfig {
    private final Map<Field, Object> values;
    private final Set<Field> defaults;
    private final Map<String, Object> leftoverValues;

    public static GraphErrorHandlingConfig parse(InputStream is, boolean strict, String parentPath) throws IOException {
        return GraphErrorHandlingConfig.parse(ConfigParser.parseRaw(is), strict, parentPath);
    }

    static GraphErrorHandlingConfig parse(InputStream is, boolean strict, String parentPath, boolean parseHiddenValues) throws IOException {
        return GraphErrorHandlingConfig.parse(ConfigParser.parseRaw(is), strict, parentPath, parseHiddenValues);
    }

    public static GraphErrorHandlingConfig parse(Map<String, Object> raw, boolean strict, String parentPath) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath);
        return new GraphErrorHandlingConfig(pr.getValues(), raw, pr.getDefaults());
    }

    static GraphErrorHandlingConfig parse(Map<String, Object> raw, boolean strict, String parentPath, boolean parseHiddenValues) {
        ParseResult pr = ConfigParser.parse(raw, (ConfigField[])Field.values(), (boolean)strict, (String)parentPath, (boolean)parseHiddenValues);
        return new GraphErrorHandlingConfig(pr.getValues(), raw, pr.getDefaults());
    }

    public static GraphErrorHandlingConfig parse(Properties props, boolean strict) {
        ParseResult pr = PropertiesConfigParser.parse((Properties)props, (ConfigField[])Field.values(), (boolean)strict);
        return new GraphErrorHandlingConfig(pr.getValues(), null, pr.getDefaults());
    }

    public static Field[] getConfigFields() {
        return Field.values();
    }

    protected GraphErrorHandlingConfig(Map<Field, Object> values, Map<String, Object> leftoverValues, Set<Field> defaults) {
        this.values = values;
        this.leftoverValues = leftoverValues == null ? Collections.emptyMap() : leftoverValues;
        this.defaults = defaults;
        this.initialize();
    }

    public Map<Field, Object> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.getValuesWithoutDefaults().isEmpty();
    }

    public boolean hasDefaultValue(Field field) {
        return this.defaults.contains(field);
    }

    @JsonValue
    public Map<Field, Object> getValuesWithoutDefaults() {
        HashMap<Field, Object> valuesWithoutDefaults = new HashMap<Field, Object>(this.values);
        for (Field field : this.defaults) {
            valuesWithoutDefaults.remove(field);
        }
        return valuesWithoutDefaults;
    }

    public Map<String, Object> getLeftoverValues() {
        return this.leftoverValues;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        if (!this.canSerialize()) {
            throw new UnsupportedOperationException("some objects part of this config cannot be serialized");
        }
        try {
            Object configValues = hideSensitiveData ? this.hiddenSensitiveData() : this;
            return ConfigJsonUtil.toJson(configValues);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private final Map<Field, Object> hiddenSensitiveData() {
        HashMap<Field, Object> hiddenValues = new HashMap<Field, Object>(this.getValuesWithoutDefaults());
        for (Field f : this.values.keySet()) {
            if (!f.isSensitive()) continue;
            hiddenValues.put(f, "*******");
        }
        return hiddenValues;
    }

    public OnMismatch getOnMissedPropKey() {
        return (OnMismatch)((Object)this.values.get(Field.ON_MISSED_PROP_KEY));
    }

    public OnMismatch getOnPropConversion() {
        return (OnMismatch)((Object)this.values.get(Field.ON_PROP_CONVERSION));
    }

    public OnMismatch getOnParsingIssue() {
        return (OnMismatch)((Object)this.values.get(Field.ON_PARSING_ISSUE));
    }

    public OnMismatch getOnTypeMismatch() {
        return (OnMismatch)((Object)this.values.get(Field.ON_TYPE_MISMATCH));
    }

    public OnMismatch getOnVectorLengthMismatch() {
        return (OnMismatch)((Object)this.values.get(Field.ON_VECTOR_LENGTH_MISMATCH));
    }

    public OnMissingVertex getOnMissingVertex() {
        return (OnMissingVertex)((Object)this.values.get(Field.ON_MISSING_VERTEX));
    }

    public OnMismatch getOnDuplicateEntityId() {
        return (OnMismatch)((Object)this.values.get(Field.ON_DUPLICATE_ENTITY_ID));
    }

    public Boolean isEnableVertexIdDuplicateCheck() {
        return (Boolean)this.values.get(Field.ENABLE_VERTEX_ID_DUPLICATE_CHECK);
    }

    public Boolean isEnableEdgeIdDuplicateCheck() {
        return (Boolean)this.values.get(Field.ENABLE_EDGE_ID_DUPLICATE_CHECK);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphErrorHandlingConfig other = (GraphErrorHandlingConfig)obj;
        if (!Objects.equals((Object)this.getOnMissedPropKey(), (Object)other.getOnMissedPropKey())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnPropConversion(), (Object)other.getOnPropConversion())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnParsingIssue(), (Object)other.getOnParsingIssue())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnTypeMismatch(), (Object)other.getOnTypeMismatch())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnVectorLengthMismatch(), (Object)other.getOnVectorLengthMismatch())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnMissingVertex(), (Object)other.getOnMissingVertex())) {
            return false;
        }
        if (!Objects.equals((Object)this.getOnDuplicateEntityId(), (Object)other.getOnDuplicateEntityId())) {
            return false;
        }
        if (!Objects.equals(this.isEnableVertexIdDuplicateCheck(), other.isEnableVertexIdDuplicateCheck())) {
            return false;
        }
        return Objects.equals(this.isEnableEdgeIdDuplicateCheck(), other.isEnableEdgeIdDuplicateCheck());
    }

    public static enum Field implements ConfigField
    {
        ON_MISSED_PROP_KEY(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.LOG_WARN_ONCE), false, false, false, false),
        ON_PROP_CONVERSION(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.LOG_WARN_ONCE), false, false, false, false),
        ON_PARSING_ISSUE(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.ERROR), false, false, false, false),
        ON_TYPE_MISMATCH(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.ERROR), false, false, false, false),
        ON_VECTOR_LENGTH_MISMATCH(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.ERROR), false, false, false, false),
        ON_MISSING_VERTEX(Collections.emptyList(), Collections.emptyList(), OnMissingVertex.class, false, (Object)((Object)OnMissingVertex.ERROR), false, false, false, false),
        ON_DUPLICATE_ENTITY_ID(Collections.emptyList(), Collections.emptyList(), OnMismatch.class, false, (Object)((Object)OnMismatch.ERROR), false, false, false, false),
        ENABLE_VERTEX_ID_DUPLICATE_CHECK(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false),
        ENABLE_EDGE_ID_DUPLICATE_CHECK(Collections.emptyList(), Collections.emptyList(), Boolean.class, false, true, false, false, false, false);

        private final List<String> aliases;
        private final List<String> singletonListAliases;
        private final Class<?> type;
        private final boolean required;
        private final Object defaultVal;
        private final boolean array;
        private final boolean path;
        private final boolean sensitive;
        private final boolean hidden;

        private Field(List<String> aliases, List<String> singletonListAliases, Class<?> type, boolean required, Object factoryDefaultVal, boolean array, boolean path, boolean sensitive, boolean hidden) {
            this.aliases = aliases;
            this.singletonListAliases = singletonListAliases;
            this.type = type;
            this.required = required;
            this.defaultVal = AbstractConfig.getDefault("graph.error.handling.json", this, factoryDefaultVal);
            this.array = array;
            this.path = path;
            this.sensitive = sensitive;
            this.hidden = hidden;
        }

        @Override
        public List<String> getKeyAliases() {
            return this.aliases;
        }

        @Override
        public List<String> getSingletonListKeyAliases() {
            return this.singletonListAliases;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public boolean isArray() {
            return this.array;
        }

        @Override
        public boolean isPath() {
            return this.path;
        }

        @Override
        public Object getDefaultVal() {
            return this.defaultVal;
        }

        @Override
        @JsonValue
        public String toKey() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.toKey();
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }
    }
}

