/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import oracle.pgx.common.UserContext;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.config.ConfigField;
import oracle.pgx.config.ConfigParser;
import oracle.pgx.config.StaticConfig;
import oracle.pgx.vfs.VirtualFile;
import oracle.pgx.vfs.VirtualFileManager;
import oracle.pgx.vfs.VirtualFileManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigFactory<T extends AbstractConfig> {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractConfigFactory.class);
    protected final VirtualFileManager vfm;
    protected final boolean parseHiddenValues;

    public AbstractConfigFactory() {
        this(false);
    }

    AbstractConfigFactory(boolean parseHiddenValues) {
        StaticConfig.get().isEnablePluginVersionChecks();
        this.vfm = VirtualFileManagerFactory.getInstance();
        this.parseHiddenValues = parseHiddenValues;
    }

    protected abstract T fromMap(Map<String, Object> var1, String var2) throws IOException;

    public abstract T fromProperties(Properties var1);

    public final T fromPath(String path) throws IOException {
        if (path.startsWith("~" + File.separator)) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        VirtualFile file = this.vfm.resolve(path, UserContext.UNAUTHENTICATED_USER_CONTEXT);
        String parentPath = file.getParent();
        LOG.debug("parse graph config from {} (parent: {})", (Object)path, (Object)parentPath);
        try (InputStream is = file.getInputStream();){
            T t = this.fromInputStream(is, parentPath);
            return t;
        }
    }

    public final T fromInputStream(InputStream is, String parentPath) throws IOException {
        return this.fromMap(ConfigParser.parseRaw(is), parentPath);
    }

    public final T fromInputStream(InputStream is) throws IOException {
        return this.fromInputStream(is, null);
    }

    public final T fromJson(String json, String parentPath) throws IOException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
            T t = this.fromInputStream(is, parentPath);
            return t;
        }
    }

    public final T fromJson(String json) throws IOException {
        return this.fromJson(json, null);
    }

    public final T fromFile(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            T t = this.fromInputStream(is, file.getParent());
            return t;
        }
    }

    public final T fromFilePath(String path) throws IOException {
        return this.fromFile(new File(path));
    }

    public final T fromProperties(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return this.fromProperties(props);
    }

    protected final boolean hasValue(ConfigField field, Function<String, Object> getter) {
        return Stream.concat(Stream.of(field.toKey()), field.getKeyAliases().stream()).map(getter).filter(Objects::nonNull).findFirst().isPresent();
    }
}

