/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import oracle.pgx.api.AlgorithmProgress;
import oracle.pgx.api.GraphLoadingProgress;
import oracle.pgx.common.Progress;

public abstract class FutureProgress {
    public static final String TYPE_ID_PROPERTY = "@type";
    @Nonnull
    private final FutureProgressType futureProgressType;
    @Nonnull
    private final Progress progress;

    public abstract Optional<GraphLoadingProgress> asGraphLoadingProgress();

    public Optional<AlgorithmProgress> asAlgorithmExecutionProgress() {
        return Optional.empty();
    }

    public FutureProgress(@Nonnull FutureProgressType futureProgressType, @Nonnull Progress progress) {
        this.futureProgressType = futureProgressType;
        this.progress = progress;
    }

    @JsonProperty(value="@type")
    @Nonnull
    public final FutureProgressType getFutureProgressType() {
        return this.futureProgressType;
    }

    @Nonnull
    public final Progress getState() {
        return this.progress;
    }

    public static enum FutureProgressType {
        DEFAULT_FUTURE_PROGRESS("DefaultFutureProgress"),
        GRAPH_LOADING_PROGRESS("GraphLoadingProgress"),
        ALGORITHM_PROGRESS("AlgorithmProgress");

        private final String typeId;

        private FutureProgressType(String typeId) {
            this.typeId = typeId;
        }

        @JsonValue
        public String getTypeId() {
            return this.typeId;
        }

        public static FutureProgressType fromTypeId(String typeId) {
            return Stream.of(FutureProgressType.values()).filter(t -> Objects.equals(typeId, t.typeId)).findAny().orElseThrow(() -> new IllegalArgumentException("Progress type not found"));
        }
    }
}

