/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.loaders.location.EntityProviderLocation;

public final class DbEntityProviderLocation
extends EntityProviderLocation {
    private final String jdbcUrl;
    private final String dataSourceId;
    private final String owner;
    private final String username;
    private final String password;
    private final String tablename;

    @JsonCreator
    public DbEntityProviderLocation(@JsonProperty(value="entityType") EntityType entityType, @JsonProperty(value="format") @Nullable ProviderFormat format, @JsonProperty(value="jdbcUrl") String jdbcUrl, @JsonProperty(value="dataSourceId") String dataSourceId, @JsonProperty(value="owner") String owner, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="tablename") String tablename) {
        super(EntityProviderLocation.LocationKind.DB, entityType, format);
        this.jdbcUrl = jdbcUrl;
        this.dataSourceId = dataSourceId;
        this.owner = owner;
        this.username = username;
        this.password = password;
        this.tablename = tablename;
        assert (format == ProviderFormat.RDBMS);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTablename() {
        return this.tablename;
    }

    @Override
    public boolean isFileLocation() {
        return false;
    }

    public String toString() {
        return "DbEntityProviderLocation{jdbcUrl='" + this.jdbcUrl + '\'' + ", dataSourceId='" + this.dataSourceId + '\'' + ", owner='" + this.owner + '\'' + ", username='" + this.username + '\'' + ", password='" + "*******" + '\'' + ", tablename='" + this.tablename + '\'' + '}';
    }
}

