/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.hypermedia.uri;

import java.net.URI;
import java.util.Map;
import oracle.pgx.common.hypermedia.uri.UriBuilderException;
import oracle.pgx.common.hypermedia.uri.UriBuilderImpl;

public abstract class UriBuilder {
    protected UriBuilder() {
    }

    protected static UriBuilder newInstance() {
        return new UriBuilderImpl();
    }

    public static UriBuilder fromUri(URI uri) {
        return UriBuilder.newInstance().uri(uri);
    }

    public static UriBuilder fromUri(String uriTemplate) {
        return UriBuilder.newInstance().uri(uriTemplate);
    }

    public static UriBuilder fromPath(String path) throws IllegalArgumentException {
        return UriBuilder.newInstance().path(path);
    }

    public abstract UriBuilder clone();

    public abstract UriBuilder uri(URI var1);

    public abstract UriBuilder uri(String var1);

    public abstract UriBuilder scheme(String var1);

    public abstract UriBuilder schemeSpecificPart(String var1);

    public abstract UriBuilder userInfo(String var1);

    public abstract UriBuilder host(String var1);

    public abstract UriBuilder port(int var1);

    public abstract UriBuilder replacePath(String var1);

    public abstract UriBuilder path(String var1);

    public abstract UriBuilder segment(String ... var1);

    public abstract UriBuilder fragment(String var1);

    public abstract UriBuilder resolveTemplate(String var1, Object var2);

    public abstract UriBuilder resolveTemplate(String var1, Object var2, boolean var3);

    public abstract UriBuilder resolveTemplateFromEncoded(String var1, Object var2);

    public abstract UriBuilder resolveTemplates(Map<String, Object> var1);

    public abstract UriBuilder resolveTemplates(Map<String, Object> var1, boolean var2) throws IllegalArgumentException;

    public abstract UriBuilder resolveTemplatesFromEncoded(Map<String, Object> var1);

    public abstract URI build(Object ... var1) throws IllegalArgumentException, UriBuilderException;

    public abstract URI build(Object[] var1, boolean var2) throws IllegalArgumentException, UriBuilderException;

    public abstract URI buildFromEncoded(Object ... var1) throws IllegalArgumentException, UriBuilderException;

    public abstract String toTemplate();
}

