/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.util.Map;
import oracle.pgx.common.OptionalComponent;
import oracle.pgx.config.PgxConfig;
import oracle.pgx.config.RuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionalComponentLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OptionalComponentLoader.class);
    private final OptionalComponent[] optionalComponents;

    public OptionalComponentLoader(OptionalComponent ... optionalComponents) {
        this.optionalComponents = optionalComponents;
    }

    public void checkOptionalComponentsAndUpdateConfig(PgxConfig pgxConfig) {
        RuntimeConfig runtimeConfig = pgxConfig.getRuntimeConfig();
        for (OptionalComponent optionalComponent : this.optionalComponents) {
            LOG.trace("Probing optional component {}", (Object)optionalComponent.getClass().getSimpleName());
            if (!optionalComponent.isComponentUsed(pgxConfig) || optionalComponent.isComponentAvailable(pgxConfig)) continue;
            String fallbackName = optionalComponent.getFallbackName().orElse("default");
            LOG.warn("{} is not available. Falling back to {}.", (Object)optionalComponent.getName(), (Object)fallbackName);
            Map<PgxConfig.Field, Object> fallBackConfigValues = optionalComponent.getFallBackConfig(pgxConfig);
            this.updateConfig(pgxConfig.getValues(), runtimeConfig.getValues(), fallBackConfigValues);
        }
    }

    private static RuntimeConfig.Field getRuntimeConfigFieldEnum(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String fieldUpperCaseName = fieldName.toUpperCase();
        try {
            return Enum.valueOf(RuntimeConfig.Field.class, fieldUpperCaseName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private void updateConfig(Map<PgxConfig.Field, Object> pgxConfigValues, Map<RuntimeConfig.Field, Object> runtimeConfigValues, Map<PgxConfig.Field, Object> updatedConfigValues) {
        updatedConfigValues.forEach((field, updatedValue) -> {
            pgxConfigValues.put((PgxConfig.Field)field, updatedValue);
            RuntimeConfig.Field runtimeConfigField = OptionalComponentLoader.getRuntimeConfigFieldEnum(field.toKey());
            if (runtimeConfigField != null) {
                runtimeConfigValues.put(runtimeConfigField, updatedValue);
            }
        });
    }

    public static void checkOptionalComponentsAndUpdateConfig(PgxConfig pgxConfig, OptionalComponent ... optionalComponents) {
        new OptionalComponentLoader(optionalComponents).checkOptionalComponentsAndUpdateConfig(pgxConfig);
    }
}

