/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.loaders.location;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.Format;
import oracle.pgx.config.GraphOptimizedFor;
import oracle.pgx.config.OnMissingVertex;
import oracle.pgx.config.ReadGraphOption;
import oracle.pgx.loaders.location.GraphLocation;

public final class PgViewGraphLocation
extends GraphLocation {
    private final String viewName;
    private final String schemaName;
    private final String jdbcUrl;
    private final String username;
    private final String password;
    private final String dataSourceId;
    private final GraphOptimizedFor optimizedFor;
    private final boolean synchronizable;
    private final OnMissingVertex onMissingVertex;
    private final Integer parallelHintDegree;

    @JsonCreator
    public PgViewGraphLocation(@JsonProperty(value="viewName") @Nonnull String viewName, @JsonProperty(value="schemaName") @Nullable String schemaName, @JsonProperty(value="optimizedFor") @Nullable GraphOptimizedFor optimizedFor, @JsonProperty(value="synchronizable") @Nullable Boolean synchronizable, @JsonProperty(value="onMissingVertex") @Nullable OnMissingVertex onMissingVertex, @JsonProperty(value="parallelHintDegree") @Nullable Integer parallelHintDegree, @JsonProperty(value="jdbcUrl") @Nullable String jdbcUrl, @JsonProperty(value="username") @Nullable String username, @JsonProperty(value="password") @Nullable String password, @JsonProperty(value="dataSourceId") @Nullable String dataSourceId) {
        super(GraphLocation.GraphLocationType.PG_VIEW_LOCATION, Format.PG);
        this.viewName = viewName;
        this.schemaName = schemaName;
        this.optimizedFor = optimizedFor;
        this.synchronizable = synchronizable == null ? false : synchronizable;
        this.onMissingVertex = onMissingVertex;
        this.parallelHintDegree = parallelHintDegree;
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dataSourceId = dataSourceId;
    }

    public static PgViewGraphLocation fromQualifiedName(String name) {
        return PgViewGraphLocation.fromQualifiedName(name, null, null, null, null, null);
    }

    public static PgViewGraphLocation fromQualifiedName(String name, List<ReadGraphOption> options) {
        return PgViewGraphLocation.fromQualifiedName(name, options, null, null, null, null);
    }

    public static PgViewGraphLocation fromQualifiedName(String name, List<ReadGraphOption> options, String jdbcUrl, String username, String password, String dataSourceId) {
        if (options != null && options.contains(ReadGraphOption.OPTIMIZED_FOR_READ) && options.contains(ReadGraphOption.OPTIMIZED_FOR_UPDATES)) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"OPTIMIZED_FOR_READ_AND_UPDATES", (Object[])new Object[0]));
        }
        ReadGraphOption.validateUnique(options, ReadGraphOption.OnMissingVertexOption.class, (String)ErrorMessages.getMessage((String)"MULTIPLE_ON_MISSING_VERTEX_OPTIONS", (Object[])new Object[0]));
        ReadGraphOption.validateUnique(options, ReadGraphOption.ParallelHintDegreeReadGraphOption.class, (String)ErrorMessages.getMessage((String)"MULTIPLE_PARALLEL_HINT_DEGREE_OPTIONS", (Object[])new Object[0]));
        int schemaEnd = 0;
        boolean inQuotes = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"') {
                if (inQuotes) {
                    if (i + 1 >= name.length() || name.charAt(i + 1) != '.') break;
                    schemaEnd = i + 1;
                    break;
                }
                inQuotes = true;
                continue;
            }
            if (c != '.' || inQuotes) continue;
            schemaEnd = i;
            break;
        }
        ReadGraphOption.ReadGraphOptionDataBuilder optionBuilder = new ReadGraphOption.ReadGraphOptionDataBuilder();
        if (options != null) {
            for (ReadGraphOption option : options) {
                option.apply(optionBuilder);
            }
        }
        String schemaName = null;
        String viewName = name;
        if (schemaEnd != 0) {
            schemaName = name.substring(0, schemaEnd);
            viewName = name.substring(schemaEnd + 1);
        }
        return new PgViewGraphLocation(viewName, schemaName, optionBuilder.getOptimizedFor(), optionBuilder.isSynchronizable(), optionBuilder.getOnMissingVertex(), optionBuilder.getParallelHintDegree(), jdbcUrl, username, password, dataSourceId);
    }

    public String getViewName() {
        return this.viewName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public boolean isFileLocation() {
        return false;
    }

    @Override
    public List<String> getFilePaths() {
        return Collections.emptyList();
    }

    public boolean isSynchronizable() {
        return this.synchronizable;
    }

    public GraphOptimizedFor getOptimizedFor() {
        return this.optimizedFor;
    }

    public OnMissingVertex getOnMissingVertex() {
        return this.onMissingVertex;
    }

    public Integer getParallelHintDegree() {
        return this.parallelHintDegree;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PgViewGraphLocation that = (PgViewGraphLocation)o;
        return this.synchronizable == that.synchronizable && Objects.equals(this.viewName, that.viewName) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.jdbcUrl, that.jdbcUrl) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.dataSourceId, that.dataSourceId) && this.optimizedFor == that.optimizedFor && this.onMissingVertex == that.onMissingVertex && Objects.equals(this.parallelHintDegree, that.parallelHintDegree);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.viewName, this.schemaName, this.jdbcUrl, this.username, this.password, this.dataSourceId, this.optimizedFor, this.synchronizable, this.onMissingVertex, this.parallelHintDegree);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean hideSensitiveData) {
        String passwordText = hideSensitiveData ? "*******" : this.password;
        return "PgViewGraphLocation{viewName='" + this.viewName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", jdbcUrl='" + this.jdbcUrl + '\'' + ", username='" + this.username + '\'' + ", password='" + passwordText + '\'' + ", dataSourceId='" + this.dataSourceId + '\'' + ", optimizedFor=" + this.optimizedFor + ", synchronizable=" + this.synchronizable + ", onMissingVertex=" + this.onMissingVertex + ", parallelHintDegree=" + this.parallelHintDegree + '}';
    }
}

