/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.mutations;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.MutationStrategy;

public class PartitionizingStrategy
extends MutationStrategy {
    private final Map<Set<String>, String> vertexLabelsToTableNameMap;
    private final Map<String, String> edgeLabelToTableNameMap;
    private final Map<PgxId, Object> vertexPropsToDropIfDefault;
    private final Map<PgxId, Object> edgePropsToDropIfDefault;
    private final String defaultVertexTableName;
    private final String defaultEdgeTableName;
    private final boolean preserveEdgeKeys;
    public static final Map<Set<String>, String> VERTEX_LABELS_TO_TABLE_AUTO = Collections.emptyMap();
    public static final Map<String, String> EDGE_LABEL_TO_TABLE_AUTO = Collections.emptyMap();
    public static final String DEFAULT_TABLE_NAME_AUTO_LABEL_BASED = null;
    private static final Map<PgxId, Object> DO_NOT_DROP_PROPERTIES = Collections.emptyMap();

    public static PartitionizingStrategy createDefaultStrategy(String newGraphName) {
        return new PartitionizingStrategy(newGraphName, null, null, VERTEX_LABELS_TO_TABLE_AUTO, EDGE_LABEL_TO_TABLE_AUTO, DO_NOT_DROP_PROPERTIES, DO_NOT_DROP_PROPERTIES, DEFAULT_TABLE_NAME_AUTO_LABEL_BASED, DEFAULT_TABLE_NAME_AUTO_LABEL_BASED, true, true, true);
    }

    public PartitionizingStrategy(String newGraphName, Map<Set<String>, String> vertexLabelsToTableNameMap, Map<String, String> edgeLabelToTableNameMap, Map<PgxId, Object> vertexPropsToDropIfDefault, Map<PgxId, Object> edgePropsToDropIfDefault, String defaultVertexTableName, String defaultEdgeTableName) {
        this(newGraphName, null, null, vertexLabelsToTableNameMap, edgeLabelToTableNameMap, vertexPropsToDropIfDefault, edgePropsToDropIfDefault, defaultVertexTableName, defaultEdgeTableName);
    }

    public PartitionizingStrategy(String newGraphName, Collection<PgxId> vertexPropIds, Collection<PgxId> edgePropIds, Map<Set<String>, String> vertexLabelsToTableNameMap, Map<String, String> edgeLabelToTableNameMap, Map<PgxId, Object> vertexPropsToDropIfDefault, Map<PgxId, Object> edgePropsToDropIfDefault, String defaultVertexTableName, String defaultEdgeTableName) {
        this(newGraphName, vertexPropIds, edgePropIds, vertexLabelsToTableNameMap, edgeLabelToTableNameMap, vertexPropsToDropIfDefault, edgePropsToDropIfDefault, defaultVertexTableName, defaultEdgeTableName, true, true, true);
    }

    public PartitionizingStrategy(String newGraphName, Collection<PgxId> vertexPropIds, Collection<PgxId> edgePropIds, Map<Set<String>, String> vertexLabelsToTableNameMap, Map<String, String> edgeLabelToTableNameMap, Map<PgxId, Object> vertexPropsToDropIfDefault, Map<PgxId, Object> edgePropsToDropIfDefault, String defaultVertexTableName, String defaultEdgeTableName, boolean generateLabelHistogram, boolean generateDegreeCaches, boolean preserveEdgeKeys) {
        super(vertexPropIds, edgePropIds, false, newGraphName, false, null, null, generateLabelHistogram, generateDegreeCaches);
        this.vertexLabelsToTableNameMap = vertexLabelsToTableNameMap;
        this.edgeLabelToTableNameMap = edgeLabelToTableNameMap;
        this.vertexPropsToDropIfDefault = vertexPropsToDropIfDefault;
        this.edgePropsToDropIfDefault = edgePropsToDropIfDefault;
        this.defaultVertexTableName = defaultVertexTableName;
        this.defaultEdgeTableName = defaultEdgeTableName;
        this.preserveEdgeKeys = preserveEdgeKeys;
    }

    @Override
    public String toString() {
        return "MutationStrategy{edgePropIds=" + this.getEdgePropIds() + ", vertexPropIds=" + this.getVertexPropIds() + ", inPlace=" + this.isInPlace() + ", newGraphName='" + this.getNewGraphName() + '\'' + ", noTrivialVertices=" + this.isNoTrivialVertices() + ", edgeStrategy=" + this.getEdgeStrategy() + ", edgeLabelMappingAction=" + (Object)((Object)this.getEdgeLabelMappingAction()) + ", vertexLabelsToTableNameMap=" + this.vertexLabelsToTableNameMap + ", edgeLabelToTableNameMap=" + this.edgeLabelToTableNameMap + ", vertexPropsToDropIfDefault=" + this.vertexPropsToDropIfDefault + ", edgePropsToDropIfDefault=" + this.edgePropsToDropIfDefault + ", defaultVertexTableName=" + this.defaultVertexTableName + ", defaultEdgeTableName=" + this.defaultEdgeTableName + ", preserveEdgeKeys=" + this.preserveEdgeKeys + ", generateLabelHistogram=" + this.isGenerateLabelHistogram() + "}";
    }

    public Map<Set<String>, String> getVertexLabelsToTableNameMap() {
        return this.vertexLabelsToTableNameMap;
    }

    public Map<String, String> getEdgeLabelToTableNameMap() {
        return this.edgeLabelToTableNameMap;
    }

    public Map<PgxId, Object> getVertexPropsToDropIfDefault() {
        return this.vertexPropsToDropIfDefault;
    }

    public Map<PgxId, Object> getEdgePropsToDropIfDefault() {
        return this.edgePropsToDropIfDefault;
    }

    public String getDefaultVertexTableName() {
        return this.defaultVertexTableName;
    }

    public boolean isPreserveEdgeKeys() {
        return this.preserveEdgeKeys;
    }

    public String getDefaultEdgeTableName() {
        return this.defaultEdgeTableName;
    }
}

