/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.pgx.client.AbstractRemoteIterator;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.JsonUtil;
import org.apache.http.client.fluent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteNodeIterator
extends AbstractRemoteIterator<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteNodeIterator.class);
    private final IdType idType;

    public RemoteNodeIterator(Executor httpExecutor, String requestUrl, String proxyId, int prefetchSize, IdType idType) {
        super(httpExecutor, requestUrl, proxyId, prefetchSize);
        this.idType = idType;
    }

    @Override
    protected Collection<Object> parseResults(String jsonString) throws JsonParseException, JsonMappingException, IOException {
        if (this.idType != null) {
            CollectionType collectionClass = JsonUtil.getTypeFactory().constructCollectionType(ArrayList.class, this.idType.getTypeClass());
            JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
            JsonParser items = JsonUtil.getValues((JsonNode)node, (String)"items");
            ArrayList fetchedValues = (ArrayList)JsonUtil.readValue((JsonParser)items, (JavaType)collectionClass);
            return fetchedValues;
        }
        LOG.warn("idType is null, I assume this means there was no entries in the List. Returning empty List.");
        return Collections.emptyList();
    }
}

