/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.MapProxy;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.client.RemoteKeyIterator;
import oracle.pgx.client.RemoteMapEntryIterator;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.NotFoundException;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.TemporalTypeUtils;
import oracle.pgx.config.LinkTemplate;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteMapProxy<K, V>
extends Self
implements MapProxy<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteMapProxy.class);
    private final String remoteMapProxyPath;
    private final Executor httpExecutor;
    private final int size;
    private final int prefetchSize;
    private final PropertyType keyType;
    private final PropertyType valueType;
    private final IdType keyNodeEdgeValueType;
    private final IdType valueNodeEdgeValueType;
    private final URI baseURI;
    private final String mapName;
    private final String mapProxyUUID;

    public RemoteMapProxy(Executor httpExecutor, String path, URI baseUri, int size, int prefetchSize, PropertyType keyType, IdType keyNodeEdgeValueType, PropertyType valueType, IdType valueNodeEdgeValueType, String mapName, String mapProxyUUID) {
        this.httpExecutor = httpExecutor;
        this.remoteMapProxyPath = RemoteUtils.stripTrailingSlash(path);
        this.size = size;
        this.prefetchSize = prefetchSize;
        this.keyType = keyType;
        this.valueType = valueType;
        this.mapProxyUUID = mapProxyUUID;
        this.baseURI = baseUri;
        this.mapName = mapName;
        if (keyType.isNodeOrEdge() && keyNodeEdgeValueType == null) {
            throw new IllegalArgumentException("if key is node/edge, keyNodeEdgeValueType must be set");
        }
        this.keyNodeEdgeValueType = keyNodeEdgeValueType;
        if (valueType.isNodeOrEdge() && valueNodeEdgeValueType == null) {
            throw new IllegalArgumentException("if value is node/edge, valueNodeEdgeValueType must be set");
        }
        this.valueNodeEdgeValueType = valueNodeEdgeValueType;
    }

    private String request(String path, K key) throws ProxyException {
        try {
            String keyStr = this.keyType.isNodeOrEdge() ? JsonUtil.toJson(key) : TemporalTypeUtils.temporalTypeToString(key);
            String url = LinkTemplate.MAP_PROXY_KEY.generateUrl(this.baseURI, new Object[0]);
            URIBuilder builder = new URIBuilder(url + path);
            Request r = Request.Get((URI)builder.build());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting " + r.toString());
            }
            r.addHeader("x-proxy-id", this.mapProxyUUID);
            r.addHeader("x-map-key", keyStr);
            return RemoteUtils.getResponseContent(this.httpExecutor.execute(r));
        }
        catch (IOException | URISyntaxException | RemoteUtils.RequestPendingException e) {
            throw new ProxyException("could not get " + path + " for the key " + key, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new ProxyException(e.getCause());
        }
    }

    public String getId() {
        throw new RuntimeException("getId() should never be called on RemoteMapProxy");
    }

    public int size() {
        return this.size;
    }

    public V get(K key) throws ProxyException {
        String responseContent = this.request("/value", key);
        try {
            Class typeClass = this.valueType.getTypeClass();
            if (this.valueType.isNodeOrEdge()) {
                typeClass = this.valueNodeEdgeValueType.getTypeClass();
            }
            JsonNode node = JsonUtil.readTopLevelJsonToTree((String)responseContent);
            String nodeValue = node.get("value").toString();
            Object value = JsonUtil.readValue((String)nodeValue, (Class)typeClass);
            return (V)value;
        }
        catch (IOException e) {
            JavaType itemClass = this.valueType == PropertyType.VERTEX ? JsonUtil.getTypeFactory().constructType(Vertex.class) : JsonUtil.getTypeFactory().constructType(Edge.class);
            try {
                JsonNode node = JsonUtil.readTopLevelJsonToTree((String)responseContent);
                String nodeValue = node.get("value").toString();
                Object value = JsonUtil.readValue((String)nodeValue, (JavaType)itemClass);
                return (V)value;
            }
            catch (IOException er) {
                throw new ProxyException("failed to parse the value for the key " + key, (Throwable)er);
            }
        }
    }

    public boolean containsKey(K key) throws ProxyException {
        try {
            try {
                String responseContent = this.request("", key);
                JsonUtil.readTopLevelJson((String)responseContent, MapProxy.KeyWrapper.class);
                return true;
            }
            catch (NotFoundException e) {
                return false;
            }
        }
        catch (IOException e) {
            throw new ProxyException("failed to parse the containsKey result for the key " + key, (Throwable)e);
        }
    }

    public Iterable<Map.Entry<K, V>> entries() throws ProxyException {
        return this.getRemoteEntryIterable(this.remoteMapProxyPath + "/entries", this.mapProxyUUID);
    }

    public Iterable<K> keys() throws ProxyException {
        return this.getRemoteKeyIterable(this.remoteMapProxyPath + "/keys");
    }

    private Iterable<Map.Entry<K, V>> getRemoteEntryIterable(String url, String proxyId) {
        return () -> new RemoteMapEntryIterator(this.httpExecutor, url, proxyId, this.prefetchSize, this.keyType, this.keyNodeEdgeValueType, this.valueType, this.valueNodeEdgeValueType);
    }

    private Iterable<K> getRemoteKeyIterable(String url) {
        return () -> {
            if (this.keyType.isNodeOrEdge()) {
                if (this.keyNodeEdgeValueType == null) {
                    throw new IllegalArgumentException("if key is node/edge, keyNodeEdgeValueType cannot be null");
                }
                return new RemoteKeyIterator(this.httpExecutor, url, this.mapProxyUUID, this.prefetchSize, this.keyType, this.keyNodeEdgeValueType);
            }
            return new RemoteKeyIterator(this.httpExecutor, url, this.mapProxyUUID, this.prefetchSize, this.keyType, null);
        };
    }

    public PropertyType getKeyType() {
        return this.keyType;
    }

    public IdType getKeyNodeEdgeValueType() {
        return this.keyNodeEdgeValueType;
    }

    public PropertyType getValueType() {
        return this.valueType;
    }

    public IdType getValueNodeEdgeValueType() {
        return this.valueNodeEdgeValueType;
    }

    public String getMapName() {
        return this.mapName;
    }
}

