/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.api.PgqlResultElement;
import oracle.pgx.api.internal.ProxyException;
import oracle.pgx.client.RemoteUtils;
import oracle.pgx.common.NotFoundException;
import oracle.pgx.common.marshalers.Marshalers;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;
import oracle.pgx.common.util.TemporalTypeUtils;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteIteratorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteIteratorUtils.class);

    protected static String prefetch(Executor httpExecutor, String requestUrl, String proxyId, long start, long prefetchSize) throws ProxyException {
        try {
            URI uri = new URIBuilder(new URI(requestUrl)).addParameter("start", String.valueOf(start)).addParameter("size", String.valueOf(prefetchSize)).build();
            Request r = Request.Get((URI)uri);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Requesting {}", (Object)r.toString());
            }
            r.addHeader("x-proxy-id", proxyId);
            return RemoteUtils.getResponseContent(httpExecutor.execute(r));
        }
        catch (IOException | URISyntaxException | RemoteUtils.RequestPendingException | NotFoundException e) {
            throw new ProxyException("Fetching more results from remote failed", e);
        }
        catch (ExecutionException e) {
            throw new ProxyException(e.getCause());
        }
    }

    protected static Collection<List<Object>> parseResults(String jsonString, int bufferSize, List<PgqlResultElement> elements) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)jsonString);
        JsonNode root = node.get("items");
        if (!root.isArray()) {
            throw new JsonParseException(ErrorMessages.getMessage((String)"UNEXPECTED_TYPE", (Object[])new Object[]{"list", "object"}), JsonLocation.NA);
        }
        return RemoteIteratorUtils.parseRows(root.elements(), bufferSize, elements);
    }

    private static Collection<List<Object>> parseRows(Iterator<JsonNode> rowIt, int bufferSize, List<PgqlResultElement> elements) throws JsonParseException {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(bufferSize);
        int rowIdx = 0;
        while (rowIt.hasNext()) {
            JsonNode row = rowIt.next();
            if (!row.isArray()) {
                throw new JsonParseException(ErrorMessages.getMessage((String)"UNEXPECTED_TYPE", (Object[])new Object[]{"list", "object"}), JsonLocation.NA);
            }
            rows.add(RemoteIteratorUtils.parseRow(row.elements(), elements));
            ++rowIdx;
        }
        return rows;
    }

    private static List<Object> parseRow(Iterator<JsonNode> colIt, List<PgqlResultElement> elements) throws JsonParseException {
        ArrayList<Object> cells = new ArrayList<Object>(elements.size());
        int colIdx = 0;
        while (colIt.hasNext()) {
            if (colIdx >= elements.size()) {
                throw new JsonParseException(ErrorMessages.getMessage((String)"UNEXPECTED_COLLECTION_SIZE", (Object[])new Object[]{elements.size(), colIdx + 1}), JsonLocation.NA);
            }
            JsonNode cell = colIt.next();
            cells.add(RemoteIteratorUtils.parseCell(cell, colIdx, elements));
            ++colIdx;
        }
        return cells;
    }

    private static Object parseCell(JsonNode cell, int colIdx, List<PgqlResultElement> elements) {
        PgqlResultElement element = elements.get(colIdx);
        PgqlResultElement.Type type = element.getElementType();
        if (cell instanceof NullNode) {
            return null;
        }
        IdType idType = element.getVertexEdgeIdType();
        if (type == PgqlResultElement.Type.ARRAY) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonNode elem : cell) {
                list.add(RemoteIteratorUtils.parsePrimitiveCell(elem, element.getCollectionElementType(), idType));
            }
            return list;
        }
        return RemoteIteratorUtils.parsePrimitiveCell(cell, type, idType);
    }

    private static Object parsePrimitiveCell(JsonNode cell, PgqlResultElement.Type type, IdType idType) {
        if (cell instanceof NullNode) {
            return null;
        }
        switch (type) {
            case VERTEX: {
                return RemoteIteratorUtils.parseVertex(cell, idType);
            }
            case EDGE: {
                return RemoteIteratorUtils.parseEdge(cell, idType);
            }
            case INTEGER: {
                return cell.asInt();
            }
            case DATE: {
                JsonNode dateNode = cell.findValue("LOCAL_DATE") == null ? cell : cell.findValue("LOCAL_DATE");
                return TemporalTypeUtils.parseLocalDate((int)dateNode.asInt());
            }
            case TIME: {
                JsonNode timeNode = cell.findValue("TIME") == null ? cell : cell.findValue("TIME");
                return TemporalTypeUtils.parseTimeFromMillis((int)timeNode.asInt());
            }
            case LONG: {
                return cell.asLong();
            }
            case TIMESTAMP: {
                JsonNode timestampNode = cell.findValue("TIMESTAMP") == null ? cell : cell.findValue("TIMESTAMP");
                return TemporalTypeUtils.parseTimestamp((long)timestampNode.asLong());
            }
            case DOUBLE: {
                return cell.asDouble();
            }
            case STRING: 
            case EDGE_LABEL: {
                return cell.asText();
            }
            case FLOAT: {
                return Float.valueOf((float)cell.asDouble());
            }
            case BOOLEAN: {
                return cell.asBoolean();
            }
            case VERTEX_LABELS: {
                HashSet<String> result = new HashSet<String>();
                for (JsonNode elem : cell) {
                    result.add(elem.textValue());
                }
                return result;
            }
            case TIME_WITH_TIMEZONE: {
                int timePart = cell.findValue("TIME_PART_OF_TIME_WITH_TZ").asInt();
                int offsetPartOfTimeWithTz = cell.findValue("TZ_PART_OF_TIME_WITH_TZ").asInt();
                return TemporalTypeUtils.parseTimeWithTimezone((int)timePart, (int)offsetPartOfTimeWithTz);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                long timestampPart = cell.findValue("TIMESTAMP_PART_OF_TS_WITH_TZ").asLong();
                int offsetPartFromTsWithTz = cell.findValue("TZ_PART_OF_TS_WITH_TZ").asInt();
                return TemporalTypeUtils.parseTimestampWithTimezone((long)timestampPart, (int)offsetPartFromTsWithTz);
            }
            case POINT2D: {
                return new Point2D(cell.findValue("x").asDouble(), cell.findValue("y").asDouble());
            }
        }
        throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"UNSUPPORTED_PGQL_RESULT_TYPE", (Object[])new Object[]{cell.elements().next()}));
    }

    private static Object parseEntity(JsonNode cell, IdType idType) {
        JsonNode entityTypeCell = cell.get("entityType");
        if (entityTypeCell == null) {
            return RemoteIteratorUtils.parseEntityLegacyFormat(cell, idType);
        }
        return RemoteIteratorUtils.parseEntityFormatWithTable(cell, entityTypeCell);
    }

    private static Object parseEntityFormatWithTable(JsonNode cell, JsonNode entityTypeCell) {
        EntityType entityType = EntityType.parseEntityType((String)entityTypeCell.asText());
        String jsonString = cell.toString();
        try {
            switch (entityType) {
                case VERTEX: {
                    return Marshalers.VERTEX_MARSHALER.unmarshal(jsonString);
                }
                case EDGE: {
                    return Marshalers.EDGE_MARSHALER.unmarshal(jsonString);
                }
            }
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_ENTITY_TYPE", (Object[])new Object[]{entityType}));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected serialized entity: " + jsonString, e);
        }
    }

    private static Object parseEntityLegacyFormat(JsonNode cell, IdType idType) {
        switch (idType) {
            case INTEGER: {
                return cell.intValue();
            }
            case LONG: {
                return cell.longValue();
            }
            case STRING: {
                return cell.textValue();
            }
        }
        throw new UnsupportedOperationException("unknown ID type: " + idType);
    }

    private static Object parseVertex(JsonNode cell, IdType type) {
        return RemoteIteratorUtils.parseEntity(cell, type);
    }

    private static Object parseEdge(JsonNode cell, IdType type) {
        return RemoteIteratorUtils.parseEntity(cell, type);
    }
}

