/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.client.BatchTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedUploader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedUploader.class);
    private final int batchSize;
    private final List<T> sourceList;
    private final Function<List<T>, PgxFuture<?>> uploadFunction;
    private final Predicate<Throwable> retryPredicate;

    public BatchedUploader(int initialBatchSize, List<T> sourceList, Function<List<T>, PgxFuture<?>> uploadFunction, Predicate<Throwable> retryPredicate) {
        this.batchSize = initialBatchSize;
        this.sourceList = sourceList;
        this.uploadFunction = uploadFunction;
        this.retryPredicate = retryPredicate;
    }

    public PgxFuture<Void> upload() {
        List<BatchTask<T>> tasks = this.createInitialListOfBatchTasks();
        return BatchTask.scheduleUploadTasks(tasks);
    }

    public List<BatchTask<T>> createInitialListOfBatchTasks() {
        ArrayList<BatchTask<T>> tasks = new ArrayList<BatchTask<T>>(this.sourceList.size() / this.batchSize);
        int listSize = this.sourceList.size();
        AtomicBoolean globalAbortFlag = new AtomicBoolean(false);
        for (int fromSplit = 0; fromSplit < listSize; fromSplit += this.batchSize) {
            int toSplit = fromSplit + this.batchSize;
            if (toSplit > listSize) {
                toSplit = listSize;
            }
            List<T> batch = this.sourceList.subList(fromSplit, toSplit);
            BatchTask<T> e = new BatchTask<T>(batch, this.uploadFunction, this.retryPredicate, globalAbortFlag);
            LOG.debug("creating initial {}", e);
            tasks.add(e);
        }
        return tasks;
    }

    public static <T> PgxFuture<Void> uploadBatched(int initialBatchSize, List<T> inputList, Predicate<Throwable> retryPredicate, Function<List<T>, PgxFuture<?>> uploadFunction) {
        return new BatchedUploader<T>(initialBatchSize, inputList, uploadFunction, retryPredicate).upload();
    }
}

