/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.redaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import oracle.pgx.api.internal.PropertyDescriptor;
import oracle.pgx.common.auth.PgxUser;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.config.PgxRedactionRuleConfig;

public abstract class PgqlRedactionContext {
    private List<PropertyDescriptor> vertexProperties = new ArrayList<PropertyDescriptor>();
    private List<PropertyDescriptor> edgeProperties = new ArrayList<PropertyDescriptor>();
    private PgxUser user = null;

    public void addVertexProperty(String name, PropertyType type) {
        this.vertexProperties.add(new PropertyDescriptor(name, type, false));
    }

    public void addVertexProperty(String name, int typeIndex) {
        this.addVertexProperty(name, PropertyType.values()[typeIndex]);
    }

    public void addEdgeProperty(String name, PropertyType type) {
        this.edgeProperties.add(new PropertyDescriptor(name, type, false));
    }

    public void addEdgeProperty(String name, int typeIndex) {
        this.addEdgeProperty(name, PropertyType.values()[typeIndex]);
    }

    public void setUser(PgxUser user) {
        this.user = user;
    }

    public List<PropertyDescriptor> getVertexProperties() {
        return this.vertexProperties;
    }

    public List<PropertyDescriptor> getEdgeProperties() {
        return this.edgeProperties;
    }

    public PgxUser getUser() {
        return this.user;
    }

    public abstract Set<PgxRedactionRuleConfig> getRedactionRules();
}

