/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.databind.JavaType;
import java.io.IOException;
import oracle.pgx.api.internal.AnalysisResult;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;

public class InvocationResultMarshaler<T>
implements Marshaler<AnalysisResult<T>> {
    private final Class<T> expectedReturnType;

    public InvocationResultMarshaler(Class<T> expectedReturnType) {
        this.expectedReturnType = expectedReturnType;
    }

    @Override
    public AnalysisResult<T> unmarshal(String jsonString) throws IOException {
        JavaType javaType = JsonUtil.getTypeFactory().constructParametricType(AnalysisResult.class, new Class[]{this.expectedReturnType});
        return (AnalysisResult)JsonUtil.readTopLevelJson((String)jsonString, (JavaType)javaType);
    }

    @Override
    public String marshal(AnalysisResult<T> object) throws IOException {
        String jsonString = JsonUtil.toJson(object);
        return jsonString;
    }
}

