/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.marshalers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.pgx.common.marshalers.Marshaler;
import oracle.pgx.common.util.JsonUtil;

public class GenericCollectionMarshaler<T>
implements Marshaler<Collection<T>> {
    private final CollectionType collectionJavaType;

    public GenericCollectionMarshaler(Class<? extends Collection> collectionType, Class<T> type) {
        this.collectionJavaType = JsonUtil.getTypeFactory().constructCollectionType(collectionType, type);
    }

    @Override
    public String marshal(Collection<T> object) throws IOException {
        return JsonUtil.toJson(object);
    }

    @Override
    public Collection<T> unmarshal(String content) throws IOException {
        JsonNode node = JsonUtil.readTopLevelJsonToTree((String)content);
        JsonParser items = JsonUtil.getValues((JsonNode)node, (String)"items");
        return (Collection)JsonUtil.readValue((JsonParser)items, (JavaType)this.collectionJavaType);
    }

    public static <T> GenericCollectionMarshaler<T> forLists(Class<T> type) {
        return new GenericCollectionMarshaler<T>(List.class, type);
    }

    public static <T> GenericCollectionMarshaler<T> forSets(Class<T> type) {
        return new GenericCollectionMarshaler<T>(Set.class, type);
    }
}

