/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.beta.annotation.BetaApi;
import oracle.pgx.api.subgraph.AbstractSubgraphReader;
import oracle.pgx.api.subgraph.PreparedPgViewPgqlQuery;
import oracle.pgx.api.subgraph.internal.KeystoreLookup;
import oracle.pgx.api.subgraph.internal.PreparedPgqlQueryBuilderImpl;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.EntityProviderConfig;
import oracle.pgx.config.GraphConfig;
import oracle.pgx.config.OnMismatch;
import oracle.pgx.config.PartitionedGraphConfig;
import oracle.pgx.config.PartitionedGraphConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.ProviderFormat;
import oracle.pgx.loaders.location.GraphLocation;
import oracle.pgx.loaders.location.PgViewGraphLocation;

@BetaApi
public class PgViewSubgraphReader
extends AbstractSubgraphReader<PgViewSubgraphReader> {
    private final String viewName;
    private final ArrayList<String> queries = new ArrayList();
    private final List<PreparedPgqlQueryBuilderImpl> preparedQueries = new ArrayList<PreparedPgqlQueryBuilderImpl>();
    private PartitionedGraphConfig config;
    private String jdbcUrl;
    private String dataSourceId;
    private String owner;
    private String username;
    private String password;
    private String keystoreAlias;
    private int numConnections;

    protected PgViewSubgraphReader(PgxSession session, KeystoreLookup keystoreLookup, String viewName, Function<GraphConfig, PgxFuture<PgxGraph>> readFunction) {
        super(session, keystoreLookup, readFunction);
        this.viewName = viewName;
    }

    @Override
    protected PgViewSubgraphReader getThis() {
        return this;
    }

    private PgxFuture<GraphConfig> buildConfig(String name) {
        PgxFuture<PartitionedGraphConfig> configFuture;
        if (this.config != null) {
            configFuture = PgxFuture.completedFuture(this.config);
        } else {
            PgViewGraphLocation graphLocation = PgViewGraphLocation.fromQualifiedName((String)this.viewName, null, (String)this.jdbcUrl, (String)this.username, (String)this.password, (String)this.dataSourceId);
            configFuture = this.session.describeGraphAsync((GraphLocation)graphLocation);
        }
        return configFuture.thenApply(graphConfig -> {
            if (!(graphConfig instanceof PartitionedGraphConfig)) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"EXPECTED_PARTITIONED_GRAPH_CONFIG", (Object[])new Object[0]));
            }
            PartitionedGraphConfig partitionedGraphConfig = (PartitionedGraphConfig)graphConfig;
            PartitionedGraphConfigBuilder configBuilder = new PartitionedGraphConfigBuilder().copyFrom(partitionedGraphConfig);
            configBuilder.setPgViewName(this.viewName);
            configBuilder.setQueries(this.queries);
            if (name != null) {
                configBuilder.setName(name);
            }
            if (this.jdbcUrl != null) {
                configBuilder.setJdbcUrl(this.jdbcUrl);
            }
            if (this.dataSourceId != null) {
                configBuilder.setDataSourceId(this.dataSourceId);
            }
            if (this.owner != null) {
                configBuilder.setSchema(this.owner);
            }
            if (this.username != null) {
                configBuilder.setUsername(this.username);
            }
            if (this.password != null) {
                configBuilder.setPassword(this.password);
            }
            if (this.keystoreAlias != null) {
                configBuilder.setKeystoreAlias(this.keystoreAlias);
            }
            if (this.numConnections > 0) {
                configBuilder.setNumConnections(this.numConnections);
            }
            if (!this.preparedQueries.isEmpty()) {
                ArrayList<PreparedQueryConfig> preparedQueryConfigs = new ArrayList<PreparedQueryConfig>(this.preparedQueries.size());
                for (PreparedPgqlQueryBuilderImpl preparedQueryBuilder : this.preparedQueries) {
                    preparedQueryConfigs.add(preparedQueryBuilder.buildQueryWithArguments());
                }
                configBuilder.setPreparedQueries(preparedQueryConfigs);
            }
            configBuilder.setErrorHandlingOnDuplicateEntityId(OnMismatch.SILENT);
            return configBuilder.build();
        });
    }

    private PgxFuture<GraphConfig> buildConfig() {
        return this.buildConfig(null);
    }

    public PgViewSubgraphReader withConfig(PartitionedGraphConfig config) {
        for (EntityProviderConfig vertexProvider : config.getVertexProviders()) {
            if (vertexProvider.getFormat() == ProviderFormat.RDBMS) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"RDBMS_PROVIDER_FORMAT_ONLY_EXPECTED", (Object[])new Object[0]));
        }
        for (EntityProviderConfig edgeProvider : config.getEdgeProviders()) {
            if (edgeProvider.getFormat() == ProviderFormat.RDBMS) continue;
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"RDBMS_PROVIDER_FORMAT_ONLY_EXPECTED", (Object[])new Object[0]));
        }
        this.config = config;
        return this;
    }

    public PgViewSubgraphReader dataSourceId(String dataSourceId) {
        this.dataSourceId = dataSourceId;
        return this;
    }

    public PgViewSubgraphReader jdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
        return this;
    }

    public PgViewSubgraphReader username(String userName) {
        this.username = userName;
        return this;
    }

    public PgViewSubgraphReader keystoreAlias(String keystoreAlias) {
        try {
            this.password(this.keystoreLookup.getPasswordForAlias(keystoreAlias));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
        this.keystoreAlias = keystoreAlias;
        return this;
    }

    public PgViewSubgraphReader password(String password) {
        this.password = password;
        return this;
    }

    public PgViewSubgraphReader schema(String schema) {
        this.owner = schema;
        return this;
    }

    public PgViewSubgraphReader owner(String owner) {
        return this.schema(owner);
    }

    public PgViewSubgraphReader connections(int numConnections) {
        this.numConnections = numConnections;
        return this;
    }

    public PgViewSubgraphReader queryPgql(String query) {
        this.queries.add(query);
        return this.getThis();
    }

    public PreparedPgViewPgqlQuery preparedPgqlQuery(String query) {
        PreparedPgqlQueryBuilderImpl queryBuilder = new PreparedPgqlQueryBuilderImpl(query);
        this.preparedQueries.add(queryBuilder);
        return new PreparedPgViewPgqlQuery(this, queryBuilder);
    }

    @Override
    public PgxFuture<PgxGraph> loadAsync() {
        return this.buildConfig().thenCompose(this.readFunction);
    }

    @Override
    public PgxFuture<PgxGraph> loadAsync(String graphName) {
        return this.buildConfig(graphName).thenCompose(this.readFunction);
    }
}

