/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.admin;

import java.util.Optional;
import oracle.pgx.common.util.function.RunnableWithException;
import oracle.pgx.common.util.function.SupplierWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogShutDown {
    private static final Logger LOG = LoggerFactory.getLogger(LogShutDown.class);

    public static void logShutdown(String shutdownPart, RunnableWithException<? extends Throwable> runnable) {
        LogShutDown.logShutdown(shutdownPart, () -> {
            runnable.runWithException();
            return null;
        });
    }

    public static <T> Optional<T> logShutdown(String shutdownPart, SupplierWithException<T, ? extends Throwable> runnable) {
        Object t;
        long start = System.currentTimeMillis();
        LOG.info(">>> [shutdown] {}", (Object)shutdownPart);
        try {
            t = runnable.getWithException();
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            LOG.error(">>> [shutdown] {} [failed: {}] ({} ms)", new Object[]{shutdownPart, throwable.getMessage(), end - start, throwable});
            return Optional.empty();
        }
        long end = System.currentTimeMillis();
        LOG.info(">>> [shutdown] {} [done] (result = {}) ({} ms)", new Object[]{shutdownPart, t, end - start});
        return Optional.ofNullable(t);
    }
}

