/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import oracle.pgx.api.GraphEntityCollection;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.internal.CollectionProxy;
import oracle.pgx.common.IdentifiableVertexCollection;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.CollectionType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;

public abstract class VertexCollection<ID>
extends GraphEntityCollection<PgxVertex<ID>, ID>
implements IdentifiableVertexCollection {
    private final Function<ID, PgxVertex<ID>> boxer = id -> new PgxVertex<Object>(this.getGraph(), id);

    VertexCollection(PgxGraph graph, PgxId collectionId, String collectionName, CollectionType type) {
        super(graph, collectionId, collectionName, type, EntityType.VERTEX);
    }

    @Override
    public IdType getIdType() {
        return this.getGraph().getVertexIdType();
    }

    @Override
    @SafeVarargs
    public final void addAllById(ID ... ids) throws ExecutionException, InterruptedException {
        this.addAllElements(this.box(this.boxer, ids));
    }

    @Override
    @SafeVarargs
    public final void removeAllById(ID ... ids) throws ExecutionException, InterruptedException {
        this.removeAllElements(this.box(this.boxer, ids));
    }

    protected GraphEntityCollection.GraphEntityProxyIterator<PgxVertex<ID>, ID> newProxyIterator(CollectionProxy proxy) {
        return new NodeProxyIterator(this.getGraph(), proxy);
    }

    private static class NodeProxyIterator<ID>
    extends GraphEntityCollection.GraphEntityProxyIterator<PgxVertex<ID>, ID> {
        NodeProxyIterator(PgxGraph graph, CollectionProxy proxy) {
            super(graph, proxy);
        }

        @Override
        protected PgxVertex<ID> newEntityObject(Object obj) {
            return PgxVertex.deserialize(this.graph, obj);
        }
    }
}

